/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.internal;

import com.google.inject.Injector;
import com.google.inject.Key;
import de.skuzzle.inject.async.internal.AsynchronousMethodInterceptor;
import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.aopalliance.intercept.MethodInvocation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class AsynchronousMethodInterceptorTest {
    @Mock
    private Injector injector;
    @InjectMocks
    private AsynchronousMethodInterceptor subject;
    @Mock
    private Key<? extends ExecutorService> key;
    @Mock
    private ExecutorService executorService;
    @Mock
    private Future<String> future;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.injector.getInstance((Key)Mockito.any(Key.class))).thenReturn((Object)this.executorService);
        Mockito.when(this.executorService.submit((Callable)Mockito.any(Callable.class))).thenReturn(this.future);
        Mockito.when((Object)this.future.get()).thenReturn((Object)"result");
    }

    private MethodInvocation mockInvocation(String methodName) throws Exception {
        Method method = this.getClass().getMethod(methodName, new Class[0]);
        MethodInvocation invocation = (MethodInvocation)Mockito.mock(MethodInvocation.class);
        Object[] args = new Object[]{};
        Mockito.when((Object)invocation.getMethod()).thenReturn((Object)method);
        Mockito.when((Object)invocation.getArguments()).thenReturn((Object)args);
        return invocation;
    }

    public String methodWithReturnType() {
        return "";
    }

    public void voidMethod() {
    }

    public Void voidWrapperMethod() {
        return null;
    }

    public Future<String> futureMethod() {
        return this.future;
    }

    @Test(expected=RuntimeException.class)
    public void testDeclineReturnType() throws Throwable {
        MethodInvocation invocation = this.mockInvocation("methodWithReturnType");
        this.subject.invoke(invocation);
    }

    @Test
    public void testInvokeVoidMethod() throws Throwable {
        MethodInvocation invocation = this.mockInvocation("voidMethod");
        Object result = this.subject.invoke(invocation);
        Assert.assertNull((Object)result);
        ((ExecutorService)Mockito.verify((Object)this.executorService)).submit((Callable)Mockito.any(Callable.class));
    }

    @Test
    public void testInvokeVoidWrapper() throws Throwable {
        MethodInvocation invocation = this.mockInvocation("voidWrapperMethod");
        Object result = this.subject.invoke(invocation);
        Assert.assertNull((Object)result);
        ((ExecutorService)Mockito.verify((Object)this.executorService)).submit((Callable)Mockito.any(Callable.class));
    }

    @Test
    public void testInvokeFuture() throws Throwable {
        MethodInvocation invocation = this.mockInvocation("futureMethod");
        Future result = (Future)this.subject.invoke(invocation);
        Assert.assertEquals((Object)"result", result.get());
    }
}

