/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.internal;

import de.skuzzle.inject.async.annotation.Trigger;
import de.skuzzle.inject.async.internal.Annotations;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class AnnotationsTest {
    @InjectMocks
    private Annotations subject;

    @Before
    public void setUp() throws Exception {
    }

    @SomeAnnotation
    @SampleTrigger
    public void withTrigger() {
    }

    @SampleTrigger
    @SecondTrigger
    public void withMultipleTriggers() {
    }

    public void withoutTrigger() {
    }

    @Test
    public void testFindTriggerAnnotation() throws Exception {
        Method method = this.getClass().getMethod("withTrigger", new Class[0]);
        Annotation result = Annotations.findTriggerAnnotation((Method)method);
        Assert.assertTrue((boolean)(result instanceof SampleTrigger));
    }

    @Test(expected=IllegalStateException.class)
    public void testFindTriggerAnnotationDuplicate() throws Exception {
        Method method = this.getClass().getMethod("withMultipleTriggers", new Class[0]);
        Annotations.findTriggerAnnotation((Method)method);
    }

    @Test(expected=IllegalStateException.class)
    public void testFindTriggerAnnotationNoAnnotation() throws Exception {
        Method method = this.getClass().getMethod("withoutTrigger", new Class[0]);
        Annotations.findTriggerAnnotation((Method)method);
    }

    @Test
    public void testPrivateCtor() throws Exception {
        Constructor ctor = Annotations.class.getDeclaredConstructor(new Class[0]);
        ctor.setAccessible(true);
        ctor.newInstance(new Object[0]);
        Assert.assertTrue((boolean)Modifier.isPrivate(ctor.getModifiers()));
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface SomeAnnotation {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Trigger
    public static @interface SecondTrigger {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Trigger
    public static @interface SampleTrigger {
    }
}

