/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.name.Names;
import de.skuzzle.inject.async.ExceptionHandler;
import de.skuzzle.inject.async.ExecutionContext;
import de.skuzzle.inject.async.GuiceAsync;
import de.skuzzle.inject.async.ScheduledContext;
import de.skuzzle.inject.async.annotation.CronTrigger;
import de.skuzzle.inject.async.annotation.CronType;
import de.skuzzle.inject.async.annotation.DelayedTrigger;
import de.skuzzle.inject.async.annotation.ExecutionScope;
import de.skuzzle.inject.async.annotation.OnError;
import de.skuzzle.inject.async.annotation.Scheduled;
import de.skuzzle.inject.async.annotation.ScheduledScope;
import de.skuzzle.inject.async.annotation.Scheduler;
import de.skuzzle.inject.async.annotation.SimpleTrigger;
import java.lang.annotation.Annotation;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import javax.inject.Inject;
import javax.inject.Named;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ScheduledIT {
    private static volatile CountDownLatch cronLatch = new CountDownLatch(2);
    private static volatile CountDownLatch simpleLatch = new CountDownLatch(2);
    private static volatile CountDownLatch delayedLatch = new CountDownLatch(2);
    private static volatile int counterSimpl;
    private static volatile int counterCron;
    @Inject
    private TestExceptionHandler testExceptionHandler;

    @Before
    public void setup() {
        Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                GuiceAsync.enableFor((Binder)this.binder());
                this.bind(TestExceptionHandler.class).asEagerSingleton();
                this.bind(TypeWithScheduledMethods.class).asEagerSingleton();
                this.bind(String.class).toInstance((Object)"foobar");
                this.bind(String.class).annotatedWith((Annotation)Names.named((String)"xxx")).toInstance((Object)"abc");
                this.bind(SomeClass.class).annotatedWith((Annotation)Names.named((String)"exec")).to(SomeClass.class).in(ExecutionScope.class);
                this.bind(SomeClass.class).annotatedWith((Annotation)Names.named((String)"sched")).to(SomeClass.class).in(ScheduledScope.class);
            }

            @Provides
            public ThreadFactory threadFactory() {
                return new ThreadFactoryBuilder().setNameFormat("it-thread").build();
            }

            @Provides
            public ScheduledExecutorService scheduler(ThreadFactory factory) {
                return Executors.newScheduledThreadPool(4, factory);
            }
        }}).injectMembers((Object)this);
    }

    @Test(timeout=30000L)
    public void testExecuteMultipleTimes() throws Exception {
        cronLatch.await();
        simpleLatch.await();
        delayedLatch.await();
        Assert.assertEquals((String)"cancel might not have worked if counter > 1", (long)1L, (long)counterSimpl);
        Assert.assertEquals((String)"cancel might not have worked if counter > 1", (long)1L, (long)counterCron);
        Assert.assertEquals((long)1L, (long)this.testExceptionHandler.getCount());
    }

    public static class TestExceptionHandler
    implements ExceptionHandler {
        private volatile int count = 0;

        public void onException(Exception e) {
            ++this.count;
        }

        public int getCount() {
            return this.count;
        }
    }

    public static class SomeClass {
    }

    public static class TypeWithScheduledMethods {
        @Scheduled
        @DelayedTrigger(value=5000L)
        private static void scheduledPrivateStaticMethod() {
            delayedLatch.countDown();
        }

        @Scheduled
        @CronTrigger(value="0/5 * * * * ?")
        private void scheduledSyso(String s, ScheduledContext ctx, ExecutionContext execCtx, @Named(value="exec") SomeClass executionScoped, @Named(value="sched") SomeClass scheduledScoped) {
            Assert.assertEquals((Object)"foobar", (Object)s);
            cronLatch.countDown();
        }

        @Scheduled
        @SimpleTrigger(value=5000L)
        public void simpleTrigger(String s, ScheduledContext ctx, ExecutionContext execCtx, @Named(value="exec") SomeClass executionScoped, @Named(value="sched") SomeClass scheduledScoped) {
            Assert.assertEquals((Object)"foobar", (Object)s);
            simpleLatch.countDown();
            throw new RuntimeException();
        }

        @Scheduled
        @DelayedTrigger(value=5000L)
        public void delayedTrigger(@Named(value="xxx") String s, ScheduledContext ctx, ExecutionContext execCtx, @Named(value="exec") SomeClass executionScoped, @Named(value="sched") SomeClass scheduledScoped) {
            Assert.assertEquals((Object)"abc", (Object)s);
            delayedLatch.countDown();
        }

        @Scheduled
        @DelayedTrigger(value=1000L)
        @Scheduler(value=ScheduledExecutorService.class)
        public void throwingException() {
            throw new UnsupportedOperationException();
        }

        @Scheduled
        @DelayedTrigger(value=1000L)
        @Scheduler(value=ScheduledExecutorService.class)
        @OnError(value=TestExceptionHandler.class)
        public void throwingExceptionWithCustomHandler() {
            throw new UnsupportedOperationException();
        }

        @Scheduled
        @SimpleTrigger(value=500L)
        public void testCancel(ScheduledContext ctx) {
            ++counterSimpl;
            ctx.cancel(true);
        }

        @Scheduled
        @CronTrigger(value="0/5 * * * * ?", cronType=CronType.QUARTZ)
        public void testCancelCron(ScheduledContext ctx) {
            ++counterCron;
            ctx.cancel(false);
        }
    }
}

