/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.Provides;
import de.skuzzle.inject.async.GuiceAsync;
import de.skuzzle.inject.async.annotation.DelayedTrigger;
import de.skuzzle.inject.async.annotation.Scheduled;
import de.skuzzle.inject.async.annotation.Scheduler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CallerRunsStrategySchedulingTest {
    @Inject
    private TypeWithScheduledMethods typeWithScheduledMethods;
    @Inject
    @Named(value="only-one-thread")
    private ScheduledExecutorService executor;

    @Before
    public void setup() {
        Guice.createInjector((Module[])new Module[]{new AbstractModule(){

            protected void configure() {
                GuiceAsync.enableFor((Binder)this.binder());
            }

            @Provides
            public ThreadFactory threadFactory() {
                return new ThreadFactoryBuilder().setNameFormat("it-thread").build();
            }

            @Provides
            @Singleton
            @Named(value="only-one-thread")
            public ScheduledExecutorService scheduler(ThreadFactory factory) {
                return new ScheduledThreadPoolExecutor(1, factory, new ThreadPoolExecutor.CallerRunsPolicy());
            }
        }}).injectMembers((Object)this);
    }

    @Test
    public void test() throws Exception {
        this.executor.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)TypeWithScheduledMethods.firstCalled);
        Assert.assertTrue((boolean)TypeWithScheduledMethods.secondCalled);
    }

    public static class TypeWithScheduledMethods {
        static volatile boolean firstCalled;
        static volatile boolean secondCalled;

        @Scheduled
        @Scheduler(value=ScheduledExecutorService.class)
        @Named(value="only-one-thread")
        @DelayedTrigger(value=0L)
        public static void takesVeryLong() {
            try {
                System.out.println("First");
                firstCalled = true;
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        @Scheduled
        @Scheduler(value=ScheduledExecutorService.class)
        @Named(value="only-one-thread")
        @DelayedTrigger(value=500L)
        public static void scheduleSecond() {
            secondCalled = true;
            System.out.println("second");
        }
    }
}

