/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.Provides;
import de.skuzzle.inject.async.GuiceAsync;
import de.skuzzle.inject.async.GuiceAsyncService;
import de.skuzzle.inject.async.annotation.Async;
import de.skuzzle.inject.async.util.Futures;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AsyncIT {
    @Inject
    private InjectMe injectMe;
    @Inject
    private GuiceAsyncService guiceAsyncService;

    @Before
    public void setup() {
        Guice.createInjector((Module[])new Module[]{new TestModule(), GuiceAsync.createModule()}).injectMembers((Object)this);
    }

    @After
    public void tearDown() {
        this.guiceAsyncService.shutdown(500L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void testVoid() throws Exception {
        String[] arg = new String[1];
        this.injectMe.asyncMethodWithVoidReturnType(arg);
        Assert.assertNull((Object)arg[0]);
        Thread.sleep(3000L);
        Assert.assertEquals((Object)"result", (Object)arg[0]);
    }

    @Test
    public void testVoidWithDefaultExecutor() throws Exception {
        String[] arg = new String[1];
        this.injectMe.asyncMethodForDefaultExecutor(arg);
        Assert.assertNull((Object)arg[0]);
        Thread.sleep(3000L);
        Assert.assertEquals((Object)"result", (Object)arg[0]);
    }

    @Test
    public void testFuture() throws Exception {
        Future<String> future = this.injectMe.asyncMethodWithFutureReturnType();
        Assert.assertEquals((Object)"result", (Object)future.get());
    }

    @Test
    public void testCompletableFuture() throws Exception {
        CompletableFuture<String> future = this.injectMe.asyncMethodWithCompletableFutureReturnType();
        Assert.assertEquals((Object)"result", (Object)future.get());
    }

    @Test(expected=ExecutionException.class)
    public void testAsynchronousException() throws Exception {
        Future<Void> future = this.injectMe.asyncMethodThrowingException();
        future.get();
    }

    public static class TestModule
    extends AbstractModule {
        protected void configure() {
            this.bind(InjectMe.class).in(Singleton.class);
        }

        @Provides
        @Named(value="sampleExecutor")
        public ExecutorService provideExecutor() {
            return Executors.newCachedThreadPool();
        }
    }

    public static class InjectMe {
        @Async
        @Named(value="sampleExecutor")
        public void asyncMethodWithVoidReturnType(String[] arg) throws InterruptedException {
            arg[0] = "result";
            Thread.sleep(2000L);
        }

        @Async
        @Named(value="sampleExecutor")
        public Future<String> asyncMethodWithFutureReturnType() throws InterruptedException {
            String result = "result";
            Thread.sleep(2000L);
            return Futures.delegate((Object)"result");
        }

        @Async
        @Named(value="sampleExecutor")
        public CompletableFuture<String> asyncMethodWithCompletableFutureReturnType() throws InterruptedException {
            String result = "result";
            Thread.sleep(2000L);
            return Futures.delegateCompletable((Object)"result");
        }

        @Async
        public void asyncMethodForDefaultExecutor(String[] arg) throws InterruptedException {
            arg[0] = "result";
            Thread.sleep(2000L);
        }

        @Async
        public Future<Void> asyncMethodThrowingException() {
            throw new UnsupportedOperationException();
        }
    }
}

