/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.internal.trigger;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.google.inject.Injector;
import de.skuzzle.inject.async.ExceptionHandler;
import de.skuzzle.inject.async.ScheduledContext;
import de.skuzzle.inject.async.TriggerStrategy;
import de.skuzzle.inject.async.annotation.DelayedTrigger;
import de.skuzzle.inject.async.internal.context.ContextFactory;
import de.skuzzle.inject.async.internal.runnables.LockableRunnable;
import de.skuzzle.inject.async.internal.runnables.RunnableBuilder;
import de.skuzzle.inject.async.util.InjectedMethodInvocation;
import java.lang.reflect.Method;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;

public class DelayedTriggerStrategy
implements TriggerStrategy {
    @Inject
    private Injector injector;
    @Inject
    private RunnableBuilder runnableBuilder;
    @Inject
    private ContextFactory contextFactory;

    public Class<DelayedTrigger> getTriggerType() {
        return DelayedTrigger.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScheduledContext schedule(Method method, Object self, ScheduledExecutorService executor, ExceptionHandler handler) {
        DelayedTrigger trigger = method.getAnnotation(this.getTriggerType());
        Preconditions.checkArgument((trigger != null ? 1 : 0) != 0, (String)"Method '%s' not annotated with @DelayedTrigger", (Object[])new Object[]{method});
        InjectedMethodInvocation invocation = InjectedMethodInvocation.forMethod(method, self, this.injector);
        ScheduledContext context = this.contextFactory.createContext(method);
        LockableRunnable stack = this.runnableBuilder.createLockedRunnableStack(invocation, context, handler);
        try {
            ScheduledFuture<?> future = executor.schedule(stack, trigger.value(), trigger.timeUnit());
            context.setFuture(future);
        }
        finally {
            stack.release();
        }
        return context;
    }
}

