/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.inject.async.internal.runnables;

import com.google.common.base.Preconditions;
import de.skuzzle.inject.async.ScheduledContext;

class ScopedRunnable
implements Runnable {
    private final Runnable wrapped;
    private final ScheduledContext context;

    private ScopedRunnable(Runnable wrapped, ScheduledContext context) {
        this.wrapped = wrapped;
        this.context = context;
    }

    static Runnable of(Runnable wrapped, ScheduledContext context) {
        Preconditions.checkArgument((wrapped != null ? 1 : 0) != 0, (Object)"wrapped is null");
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"context is null");
        return new ScopedRunnable(wrapped, context);
    }

    @Override
    public void run() {
        try {
            this.context.beginNewExecution();
            this.wrapped.run();
        }
        finally {
            this.context.finishExecution();
        }
    }
}

