/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Whitespaces {
    private static final Pattern LEADING = Pattern.compile("^\\s+");
    private static final Pattern TRAILING = Pattern.compile("\\s+$");

    public static final String trimAll(String s) {
        Matcher leadingMatcher = LEADING.matcher(s);
        Matcher trailingMatcher = TRAILING.matcher(s);
        boolean hasLeading = leadingMatcher.find();
        boolean hasTrailing = trailingMatcher.find();
        if (!hasLeading && !hasTrailing) {
            return s;
        }
        int start = hasLeading ? leadingMatcher.end() : 0;
        int end = hasTrailing ? trailingMatcher.start() : s.length();
        return s.substring(start, end);
    }

    private Whitespaces() {
    }
}

