/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports.parser.lang;

import com.github.javaparser.ParserConfiguration;
import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.MarkerAnnotationExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithName;
import com.github.javaparser.ast.nodeTypes.NodeWithType;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import de.skuzzle.enforcer.restrictimports.parser.ImportStatement;
import de.skuzzle.enforcer.restrictimports.parser.ImportType;
import de.skuzzle.enforcer.restrictimports.parser.ParsedFile;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

final class JavaCompilationUnitParser {
    JavaCompilationUnitParser() {
    }

    public ParsedFile parseCompilationUnit(Path sourceFilePath, Charset charset) throws IOException {
        StaticJavaParser.getParserConfiguration().setCharacterEncoding(charset);
        StaticJavaParser.getParserConfiguration().setLexicalPreservationEnabled(false);
        StaticJavaParser.getParserConfiguration().setLanguageLevel(ParserConfiguration.LanguageLevel.RAW);
        CompilationUnit compilationUnit = StaticJavaParser.parse(sourceFilePath);
        List<ImportStatement> imports = compilationUnit.getImports().stream().map(id -> new ImportStatement(id.isAsterisk() ? id.getNameAsString() + ".*" : id.getNameAsString(), id.getBegin().map(p -> p.line).orElse(0), id.isStatic() ? ImportType.STATIC_IMPORT : ImportType.IMPORT)).collect(Collectors.toList());
        compilationUnit.stream().map(this::nodeToImportStatement).filter(Optional::isPresent).map(Optional::get).forEach(imports::add);
        String fileName = this.getFileNameWithoutExtension(sourceFilePath);
        String declaredPackage = compilationUnit.getPackageDeclaration().map(NodeWithName::getNameAsString).orElse("");
        String primaryTypeName = compilationUnit.getPrimaryTypeName().orElse(fileName);
        String fqcn = declaredPackage.isEmpty() ? primaryTypeName : declaredPackage + "." + primaryTypeName;
        return ParsedFile.successful(sourceFilePath, declaredPackage, fqcn, imports);
    }

    private int positionOf(Node node) {
        return node.getBegin().map(p -> p.line).orElse(0);
    }

    private Optional<ImportStatement> nodeToImportStatement(Node node) {
        if (node instanceof NodeWithType) {
            NodeWithType expr = (NodeWithType)((Object)node);
            Object type = expr.getType();
            if (type instanceof ClassOrInterfaceType && ((ClassOrInterfaceType)type).getScope().isPresent()) {
                ClassOrInterfaceType classType = (ClassOrInterfaceType)expr.getType();
                return Optional.of(new ImportStatement(classType.getNameWithScope(), this.positionOf(node), ImportType.QUALIFIED_TYPE_USE));
            }
        } else {
            MarkerAnnotationExpr expr;
            boolean isQualified;
            if (node instanceof MethodCallExpr) {
                MethodCallExpr expr2 = (MethodCallExpr)node;
                FieldAccessExpr accessExpr = expr2.findFirst(FieldAccessExpr.class).orElse(null);
                if (accessExpr == null || accessExpr.getScope() == null) {
                    return Optional.empty();
                }
                return Optional.of(new ImportStatement(accessExpr.getScope() + "." + accessExpr.getName(), this.positionOf(node), ImportType.QUALIFIED_TYPE_USE));
            }
            if (node instanceof MarkerAnnotationExpr && (isQualified = (expr = (MarkerAnnotationExpr)node).getName().getQualifier().isPresent())) {
                return Optional.of(new ImportStatement(expr.getNameAsString(), this.positionOf(node), ImportType.QUALIFIED_TYPE_USE));
            }
        }
        return Optional.empty();
    }

    private String getFileNameWithoutExtension(Path file) {
        String s = file.getFileName().toString();
        int i = s.lastIndexOf(".");
        return s.substring(0, i);
    }
}

