/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports.parser;

import de.skuzzle.enforcer.restrictimports.parser.Annotation;
import de.skuzzle.enforcer.restrictimports.parser.ImportStatement;
import de.skuzzle.enforcer.restrictimports.util.Preconditions;
import de.skuzzle.enforcer.restrictimports.util.StringRepresentation;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class ParsedFile {
    private final Path path;
    private final String declaredPackage;
    private final String fqcn;
    private final Collection<ImportStatement> imports;
    private final boolean failedToParse;
    private final List<Annotation> annotations;

    private ParsedFile(Path path, String declaredPackage, String fqcn, Collection<ImportStatement> imports, boolean failedToParse, List<Annotation> annotations) {
        Preconditions.checkArgument(path != null, "path must not be null", new Object[0]);
        Preconditions.checkArgument(declaredPackage != null, "declaredPackage must not be null", new Object[0]);
        Preconditions.checkArgument(fqcn != null, "fqcn must not be null", new Object[0]);
        Preconditions.checkArgument(imports != null, "imports must not be null", new Object[0]);
        Preconditions.checkArgument(annotations != null, "annotations must not be null", new Object[0]);
        Preconditions.checkState(!failedToParse || !annotations.isEmpty(), "annotations must not be empty if failedToParse was true", new Object[0]);
        this.path = path;
        this.declaredPackage = declaredPackage;
        this.fqcn = fqcn;
        this.imports = imports;
        this.failedToParse = failedToParse;
        this.annotations = annotations;
    }

    public static ParsedFile successful(Path path, String declaredPackage, String fqcn, Collection<ImportStatement> imports) {
        return new ParsedFile(path, declaredPackage, fqcn, imports, false, Collections.emptyList());
    }

    public static ParsedFile failedToParse(Path path, Annotation ... annotations) {
        return new ParsedFile(path, "", "", Collections.emptyList(), true, Arrays.asList(annotations));
    }

    public ParsedFile andAddAnnotation(Annotation ... furtherAnnotations) {
        ArrayList<Annotation> allAnnotations = new ArrayList<Annotation>(this.annotations);
        allAnnotations.addAll(Arrays.asList(furtherAnnotations));
        return new ParsedFile(this.path, this.declaredPackage, this.fqcn, this.imports, this.failedToParse, allAnnotations);
    }

    public Path getPath() {
        return this.path;
    }

    public Collection<ImportStatement> getImports() {
        return this.imports;
    }

    public String getFqcn() {
        return this.fqcn;
    }

    public boolean isFailedToParse() {
        return this.failedToParse;
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public String toString() {
        return StringRepresentation.ofInstance(this).add("path", this.path).add("declaredPackage", this.declaredPackage).add("fqcn", this.fqcn).add("imports", this.imports).add("annotations", this.annotations).add("failedToParse", this.failedToParse).toString();
    }

    public int hashCode() {
        return Objects.hash(this.path, this.declaredPackage, this.fqcn, this.imports, this.failedToParse, this.annotations);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof ParsedFile && Objects.equals(this.path, ((ParsedFile)obj).path) && Objects.equals(this.declaredPackage, ((ParsedFile)obj).declaredPackage) && Objects.equals(this.fqcn, ((ParsedFile)obj).fqcn) && Objects.equals(this.imports, ((ParsedFile)obj).imports) && Objects.equals(this.annotations, ((ParsedFile)obj).annotations) && this.failedToParse == ((ParsedFile)obj).failedToParse;
    }
}

