/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports.parser;

import de.skuzzle.enforcer.restrictimports.util.Preconditions;
import de.skuzzle.enforcer.restrictimports.util.StringRepresentation;
import java.util.Objects;

public final class Annotation {
    private final String message;

    private Annotation(String message) {
        Preconditions.checkArgument(message != null, "message must not be null", new Object[0]);
        this.message = message;
    }

    public static Annotation withMessage(String message) {
        return new Annotation(message);
    }

    public String getMessage() {
        return this.message;
    }

    public int hashCode() {
        return Objects.hash(this.message);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof Annotation && Objects.equals(this.message, ((Annotation)obj).message);
    }

    public String toString() {
        return StringRepresentation.ofInstance(this).add("message", this.message).toString();
    }
}

