/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports.formatting;

import de.skuzzle.enforcer.restrictimports.analyze.AnalyzeResult;
import de.skuzzle.enforcer.restrictimports.analyze.BannedImportGroup;
import de.skuzzle.enforcer.restrictimports.analyze.MatchedFile;
import de.skuzzle.enforcer.restrictimports.analyze.MatchedImport;
import de.skuzzle.enforcer.restrictimports.analyze.Warning;
import de.skuzzle.enforcer.restrictimports.formatting.DurationFormat;
import de.skuzzle.enforcer.restrictimports.formatting.MatchFormatter;
import de.skuzzle.enforcer.restrictimports.util.Preconditions;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class MatchFormatterImpl
implements MatchFormatter {
    static final MatchFormatter INSTANCE = new MatchFormatterImpl();

    MatchFormatterImpl() {
    }

    @Override
    public String formatMatches(AnalyzeResult analyzeResult) {
        StringBuilder b = new StringBuilder();
        if (analyzeResult.bannedImportsInCompileCode()) {
            b.append("\nBanned imports detected:\n\n");
            Map<BannedImportGroup, List<MatchedFile>> srcMatchesByGroup = analyzeResult.srcMatchesByGroup();
            this.formatGroupedMatches(b, srcMatchesByGroup);
        }
        if (analyzeResult.bannedImportsInTestCode()) {
            b.append("\nBanned imports detected in TEST code:\n\n");
            Map<BannedImportGroup, List<MatchedFile>> testMatchesByGroup = analyzeResult.testMatchesByGroup();
            this.formatGroupedMatches(b, testMatchesByGroup);
        }
        if (analyzeResult.warningsFound()) {
            b.append("\nBanned imports analysis completed with warnings. Results may be inaccurate!\n\n");
            this.formatWarnings(b, analyzeResult);
            b.append("\n\tRun the build with debug information to see error details about the warning\n");
        }
        Duration duration = analyzeResult.duration();
        b.append("\nAnalysis of ").append(MatchFormatterImpl.pluralize(analyzeResult.analysedFiles(), " file")).append(" took ").append(DurationFormat.formatDuration(duration)).append("\n");
        return b.toString();
    }

    private void formatWarnings(StringBuilder b, AnalyzeResult analyzeResult) {
        List allFilesWithWarning = Stream.concat(analyzeResult.getSrcMatches().stream(), analyzeResult.getTestMatches().stream()).filter(MatchedFile::hasWarning).collect(Collectors.toList());
        List<Warning> distinctWarnings = allFilesWithWarning.stream().map(MatchedFile::getWarnings).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        distinctWarnings.forEach(warning -> {
            b.append("\t").append(warning.getMessage()).append(":\n");
            allFilesWithWarning.stream().filter(matchedFile -> matchedFile.getWarnings().contains(warning)).forEach(matchedFile -> b.append("\t\tfile://").append(matchedFile.getSourceFile()).append("\n"));
        });
    }

    private static String pluralize(long value, String singular) {
        return value == 1L ? value + singular : value + singular + "s";
    }

    private void formatGroupedMatches(StringBuilder b, Map<BannedImportGroup, List<MatchedFile>> matchesByGroup) {
        int longestMatchedString = this.longestMatch(matchesByGroup.values());
        matchesByGroup.forEach((group, matches) -> {
            group.getReason().ifPresent(reason -> b.append("Reason: ").append((String)reason).append("\n"));
            matches.forEach(fileMatch -> {
                b.append("\tin file://").append(fileMatch.getSourceFile().toAbsolutePath());
                if (fileMatch.hasWarning()) {
                    b.append(" (!)");
                }
                b.append("\n");
                fileMatch.getMatchedImports().forEach(match -> this.appendMatch((MatchedImport)match, longestMatchedString, b));
            });
        });
    }

    private int longestMatch(Collection<? extends Collection<MatchedFile>> files) {
        return files.stream().flatMap(Collection::stream).map(MatchedFile::getMatchedImports).flatMap(Collection::stream).map(MatchedImport::getMatchedString).mapToInt(String::length).max().orElse(1);
    }

    private void appendMatch(MatchedImport match, int longestMatchedString, StringBuilder b) {
        b.append("\t\t").append(this.padRight(match.getMatchedString(), longestMatchedString)).append(" \t(Line: ").append(match.getImportLine()).append(", Matched by: ").append(match.getMatchedBy()).append(")\n");
    }

    private String padRight(String original, int intendedLength) {
        Preconditions.checkArgument(original.length() <= intendedLength);
        int diff = intendedLength - original.length();
        StringBuilder builder = new StringBuilder(intendedLength).append(original);
        for (int i = 0; i < diff; ++i) {
            builder.append(" ");
        }
        return builder.toString();
    }
}

