/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports.analyze;

import de.skuzzle.enforcer.restrictimports.util.Preconditions;
import de.skuzzle.enforcer.restrictimports.util.Whitespaces;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class PackagePattern
implements Comparable<PackagePattern> {
    private static final String STATIC_PREFIX = "static";
    private final String[] parts;
    private final boolean staticc;

    private PackagePattern(String s) {
        ParseResult parsed = ParseResult.parse(s);
        this.staticc = parsed.staticc;
        this.parts = parsed.parts;
        this.checkParts(s, this.parts);
    }

    private void checkParts(String original, String[] parts) {
        if (original.startsWith(".") || original.endsWith(".")) {
            throw new IllegalArgumentException(String.format("The pattern '%s' contains an empty part", original));
        }
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            this.checkCharacters(original, part, i);
        }
    }

    private void checkCharacters(String original, String part, int partIndex) {
        char[] chars = part.toCharArray();
        if (part.isEmpty()) {
            throw new IllegalArgumentException(String.format("The pattern '%s' contains an empty part", original));
        }
        if (this.isValidWildcardPart(part)) {
            return;
        }
        if (part.contains("*") && (part.indexOf(42) > 1 || part.indexOf(42) < part.length() - 2)) {
            throw new IllegalArgumentException(String.format("The pattern '%s' contains a part which mixes wildcards and normal characters", original));
        }
        if (partIndex == 0 && STATIC_PREFIX.equals(part)) {
            return;
        }
        if (!Character.isJavaIdentifierStart(chars[0])) {
            throw new IllegalArgumentException(String.format("The pattern '%s' contains a non-identifier character '%s' (0x%s)", original, Character.valueOf(chars[0]), Integer.toHexString(chars[0])));
        }
        for (int i = 1; i < chars.length; ++i) {
            char c = chars[i];
            if (Character.isJavaIdentifierPart(c)) continue;
            throw new IllegalArgumentException(String.format("The pattern '%s' contains a non-identifier character '%s' (0x%s)", original, Character.valueOf(chars[i]), Integer.toHexString(chars[i])));
        }
    }

    private boolean isValidWildcardPart(String patternPart) {
        if ("*".equals(patternPart) || "**".equals(patternPart) || "'*'".equals(patternPart)) {
            return true;
        }
        if (patternPart.startsWith("*") || patternPart.endsWith("*")) {
            String substring = patternPart.substring(1, patternPart.length() - 1);
            return !substring.contains("*");
        }
        return false;
    }

    public static List<PackagePattern> parseAll(Collection<String> patternStrings) {
        Preconditions.checkArgument(patternStrings != null);
        return patternStrings.stream().map(PackagePattern::parse).collect(Collectors.toList());
    }

    public static PackagePattern parse(String patternString) {
        Preconditions.checkArgument(patternString != null);
        return new PackagePattern(patternString);
    }

    public boolean matches(PackagePattern otherPackagePattern) {
        if (otherPackagePattern == this) {
            return true;
        }
        return PackagePattern.matchesInternal(otherPackagePattern.staticc, otherPackagePattern.parts, this.staticc, this.parts);
    }

    public boolean matches(String packageName) {
        ParseResult parsed = ParseResult.parse(packageName);
        return PackagePattern.matchesInternal(parsed.staticc, parsed.parts, this.staticc, this.parts);
    }

    private static boolean matchesInternal(boolean matchIsStatic, String[] matchParts, boolean patternIsStatic, String[] patternParts) {
        int patternIndex;
        if (patternIsStatic && !matchIsStatic) {
            return false;
        }
        if (patternParts.length > matchParts.length) {
            return false;
        }
        int matchIndex = 0;
        for (patternIndex = 0; patternIndex < patternParts.length && matchIndex < matchParts.length; ++patternIndex) {
            String patternPart = patternParts[patternIndex];
            String matchPart = matchParts[matchIndex];
            if ("**".equals(patternPart)) {
                if (patternIndex + 1 < patternParts.length) {
                    ++matchIndex;
                    String nextPatternPart = patternParts[patternIndex + 1];
                    while (matchIndex < matchParts.length && !PackagePattern.matchParts(nextPatternPart, matchParts[matchIndex])) {
                        ++matchIndex;
                    }
                    continue;
                }
                matchIndex = matchParts.length;
                continue;
            }
            if (PackagePattern.matchParts(patternPart, matchPart)) {
                ++matchIndex;
                continue;
            }
            return false;
        }
        return patternIndex == patternParts.length && matchIndex == matchParts.length;
    }

    private static boolean matchParts(String patternPart, String matchPart) {
        if ("*".equals(patternPart) || "**".equals(patternPart)) {
            return true;
        }
        if ("'*'".equals(patternPart)) {
            return matchPart.equals("*");
        }
        if (patternPart.startsWith("*") && patternPart.endsWith("*")) {
            String infix = patternPart.substring(1, patternPart.length() - 1);
            return matchPart.contains(infix);
        }
        if (patternPart.startsWith("*")) {
            String suffix = patternPart.substring(1);
            return matchPart.endsWith(suffix);
        }
        if (patternPart.endsWith("*")) {
            String prefix = patternPart.substring(0, patternPart.length() - 1);
            return matchPart.startsWith(prefix);
        }
        return patternPart.equals(matchPart);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.staticc) {
            result.append("static ");
        }
        result.append(String.join((CharSequence)".", this.parts));
        return result.toString();
    }

    @Override
    public int compareTo(PackagePattern other) {
        int commonParts = Math.min(this.parts.length, other.parts.length);
        for (int i = 0; i < commonParts; ++i) {
            String thisPart = this.parts[i];
            String otherPart = other.parts[i];
            if (thisPart.equals(otherPart)) continue;
            int leftSpecificity = this.specificityOf(thisPart);
            int rightSpecificity = this.specificityOf(otherPart);
            return Integer.compare(leftSpecificity, rightSpecificity);
        }
        return Integer.compare(this.parts.length, other.parts.length);
    }

    private int specificityOf(String part) {
        if (part.equals("**")) {
            return 0;
        }
        if (part.contains("*")) {
            return 1;
        }
        return 2;
    }

    public boolean isStatic() {
        return this.staticc;
    }

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.parts), this.staticc);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof PackagePattern && this.staticc == ((PackagePattern)obj).staticc && Arrays.equals(this.parts, ((PackagePattern)obj).parts);
    }

    private static class ParseResult {
        private static final Pattern STATIC_PREFIX_PATTERN = Pattern.compile("^static\\s+");
        private final String[] parts;
        private final boolean staticc;

        private ParseResult(String[] parts, boolean staticc) {
            this.parts = parts;
            this.staticc = staticc;
        }

        static ParseResult parse(String s) {
            String trimmed = Whitespaces.trimAll(s);
            Matcher matcher = STATIC_PREFIX_PATTERN.matcher(trimmed);
            boolean staticc = matcher.find();
            if (staticc) {
                trimmed = trimmed.substring(matcher.end());
            }
            String[] parts = trimmed.split("\\.");
            return new ParseResult(parts, staticc);
        }
    }
}

