/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports.analyze;

import de.skuzzle.enforcer.restrictimports.analyze.BannedImportDefinitionException;
import de.skuzzle.enforcer.restrictimports.analyze.PackagePattern;
import de.skuzzle.enforcer.restrictimports.util.StringRepresentation;
import java.util.List;

public final class NotFixable {
    private final PackagePattern in;
    private final List<PackagePattern> imports;

    private NotFixable(PackagePattern in, List<PackagePattern> imports) {
        this.in = in;
        this.imports = imports;
    }

    public static NotFixable of(PackagePattern in, List<PackagePattern> imports) {
        return new NotFixable(in, imports);
    }

    public boolean matchesFqcn(String fqcn) {
        return this.in.matches(fqcn);
    }

    public boolean matchesImport(String importName) {
        return this.imports.stream().anyMatch(pattern -> pattern.matches(importName));
    }

    public void checkConsistency() {
        if (this.imports.isEmpty()) {
            throw new BannedImportDefinitionException("No 'not fixable' imports defined for " + this.in);
        }
    }

    public String toString() {
        return StringRepresentation.ofInstance(this).add("in", this.in).add("imports", this.imports).toString();
    }
}

