/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports.analyze;

import de.skuzzle.enforcer.restrictimports.analyze.BannedImportDefinitionException;
import de.skuzzle.enforcer.restrictimports.analyze.NotFixable;
import de.skuzzle.enforcer.restrictimports.analyze.PackagePattern;
import de.skuzzle.enforcer.restrictimports.util.StringRepresentation;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class BannedImportGroup {
    private final List<PackagePattern> basePackages;
    private final List<PackagePattern> bannedImports;
    private final List<PackagePattern> allowedImports;
    private final List<PackagePattern> exclusions;
    private final List<NotFixable> notFixables;
    private final String reason;

    private BannedImportGroup(List<PackagePattern> basePackages, List<PackagePattern> bannedImports, List<PackagePattern> allowedImports, List<PackagePattern> exclusions, List<NotFixable> notFixables, String reason) {
        this.basePackages = basePackages;
        this.bannedImports = bannedImports;
        this.allowedImports = allowedImports;
        this.exclusions = exclusions;
        this.notFixables = notFixables;
        this.reason = reason;
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<PackagePattern> getBasePackages() {
        return this.basePackages;
    }

    public boolean basePackageMatches(String fqcn) {
        return this.matchesAnyPattern(fqcn, this.basePackages);
    }

    public List<PackagePattern> getBannedImports() {
        return this.bannedImports;
    }

    public Optional<PackagePattern> ifImportIsBanned(String fqcn, String importName) {
        return this.bannedImports.stream().filter(bannedImport -> bannedImport.matches(importName)).filter(result -> !this.allowedImportMatches(importName)).filter(result -> !this.isNotFixable(fqcn, importName)).findFirst();
    }

    public List<PackagePattern> getAllowedImports() {
        return this.allowedImports;
    }

    private boolean allowedImportMatches(String importName) {
        return this.matchesAnyPattern(importName, this.allowedImports);
    }

    private boolean isNotFixable(String fqcn, String importName) {
        return this.notFixables.stream().filter(notFixable -> notFixable.matchesFqcn(fqcn)).anyMatch(notFixable -> notFixable.matchesImport(importName));
    }

    public List<PackagePattern> getExclusions() {
        return this.exclusions;
    }

    public boolean exclusionMatches(String fqcn) {
        return this.matchesAnyPattern(fqcn, this.exclusions);
    }

    private boolean matchesAnyPattern(String packageName, Collection<PackagePattern> patterns) {
        return patterns.stream().anyMatch(pattern -> pattern.matches(packageName));
    }

    public Optional<String> getReason() {
        return Optional.ofNullable(this.reason).filter(s -> !s.isEmpty());
    }

    boolean hasNotFixables() {
        return !this.notFixables.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.basePackages, this.bannedImports, this.allowedImports, this.exclusions, this.notFixables, this.reason);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof BannedImportGroup && Objects.equals(this.basePackages, ((BannedImportGroup)obj).basePackages) && Objects.equals(this.bannedImports, ((BannedImportGroup)obj).bannedImports) && Objects.equals(this.allowedImports, ((BannedImportGroup)obj).allowedImports) && Objects.equals(this.exclusions, ((BannedImportGroup)obj).exclusions) && Objects.equals(this.notFixables, ((BannedImportGroup)obj).notFixables) && Objects.equals(this.reason, ((BannedImportGroup)obj).reason);
    }

    public String toString() {
        return StringRepresentation.ofInstance(this).add("basePackages", this.basePackages).add("bannedImports", this.bannedImports).add("allowedImports", this.allowedImports).add("exclusions", this.exclusions).add("notFixables", this.notFixables).add("reason", this.reason).toString();
    }

    public static class Builder {
        private List<PackagePattern> basePackages = Collections.emptyList();
        private List<PackagePattern> bannedImports = Collections.emptyList();
        private List<PackagePattern> allowedImports = Collections.emptyList();
        private List<PackagePattern> exclusions = Collections.emptyList();
        private List<NotFixable> notFixables = Collections.emptyList();
        private String reason;

        private Builder() {
        }

        public Builder withBasePackages(List<PackagePattern> basePackages) {
            this.basePackages = basePackages;
            return this;
        }

        public Builder withBasePackages(String ... basePackages) {
            return this.withBasePackages(PackagePattern.parseAll(Arrays.asList(basePackages)));
        }

        public Builder withBannedImports(List<PackagePattern> bannedImports) {
            this.bannedImports = bannedImports;
            return this;
        }

        public Builder withBannedImports(String ... bannedImports) {
            return this.withBannedImports(PackagePattern.parseAll(Arrays.asList(bannedImports)));
        }

        public Builder withAllowedImports(List<PackagePattern> allowedImports) {
            this.allowedImports = allowedImports;
            return this;
        }

        public Builder withAllowedImports(String ... allowedImports) {
            return this.withAllowedImports(PackagePattern.parseAll(Arrays.asList(allowedImports)));
        }

        public Builder withExclusions(List<PackagePattern> exclusions) {
            this.exclusions = exclusions;
            return this;
        }

        public Builder withExclusions(String ... exclusions) {
            return this.withExclusions(PackagePattern.parseAll(Arrays.asList(exclusions)));
        }

        public Builder withReason(String reason) {
            this.reason = reason;
            return this;
        }

        public Builder withNotFixables(NotFixable ... notFixables) {
            return this.withNotFixables(Arrays.asList(notFixables));
        }

        public Builder withNotFixables(List<NotFixable> notFixables) {
            this.notFixables = notFixables;
            return this;
        }

        public BannedImportGroup build() {
            BannedImportGroup group = new BannedImportGroup(this.basePackages, this.bannedImports, this.allowedImports, this.exclusions, this.notFixables, this.reason);
            this.checkGroupConsistency(group);
            return group;
        }

        private void checkGroupConsistency(BannedImportGroup group) {
            this.checkAmbiguous(group);
            this.checkBasePackagesPresent(group);
            this.checkBannedImportsPresent(group);
            this.allowedImportMustMatchBannedPattern(group);
            this.checkBasePackageNotStatic(group);
            this.checkExclusionNotStatic(group);
            this.exclusionsMustMatchBasePattern(group);
            this.checkNotFixables(group);
        }

        private void checkNotFixables(BannedImportGroup group) {
            group.notFixables.forEach(NotFixable::checkConsistency);
        }

        private void checkAmbiguous(BannedImportGroup group) {
            this.checkAmbiguous(group.getBasePackages(), "base package");
            this.checkAmbiguous(group.getBannedImports(), "banned import");
            this.checkAmbiguous(group.getAllowedImports(), "allowed import");
            this.checkAmbiguous(group.getExclusions(), "exclusion");
        }

        private void checkAmbiguous(Collection<PackagePattern> patterns, String errorTemplate) {
            for (PackagePattern outer : patterns) {
                for (PackagePattern inner : patterns) {
                    if (inner == outer || !inner.matches(outer)) continue;
                    throw new BannedImportDefinitionException(String.format("There are ambiguous %s definitions: %s, %s", errorTemplate, inner, outer));
                }
            }
        }

        private void checkBasePackageNotStatic(BannedImportGroup group) {
            if (group.getBasePackages().stream().anyMatch(PackagePattern::isStatic)) {
                throw new BannedImportDefinitionException("Base packages must not be static");
            }
        }

        private void checkExclusionNotStatic(BannedImportGroup group) {
            if (group.getExclusions().stream().anyMatch(PackagePattern::isStatic)) {
                throw new BannedImportDefinitionException("Exclusions must not be static");
            }
        }

        private void checkBasePackagesPresent(BannedImportGroup group) {
            if (group.getBasePackages().isEmpty()) {
                throw new BannedImportDefinitionException("There are not base packages specified");
            }
        }

        private void checkBannedImportsPresent(BannedImportGroup group) {
            if (group.getBannedImports().isEmpty()) {
                throw new BannedImportDefinitionException("There are no banned imports specified");
            }
        }

        private void allowedImportMustMatchBannedPattern(BannedImportGroup group) {
            for (PackagePattern allowedImport : group.getAllowedImports()) {
                boolean matches = group.getBannedImports().stream().anyMatch(bannedPackage -> bannedPackage.matches(allowedImport));
                if (matches) continue;
                throw new BannedImportDefinitionException(String.format("The allowed import pattern '%s' does not match any banned package.", allowedImport));
            }
        }

        private void exclusionsMustMatchBasePattern(BannedImportGroup group) {
            for (PackagePattern excludedClass : group.getExclusions()) {
                boolean matches = group.getBasePackages().stream().anyMatch(basePackage -> basePackage.matches(excludedClass));
                if (matches) continue;
                throw new BannedImportDefinitionException(String.format("The exclusion pattern '%s' does not match any base package.", excludedClass));
            }
        }
    }
}

