/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import de.skuzzle.enforcer.restrictimports.analyze.AnalyzeResult;
import de.skuzzle.enforcer.restrictimports.analyze.AnalyzerSettings;
import de.skuzzle.enforcer.restrictimports.analyze.BannedImportDefinitionException;
import de.skuzzle.enforcer.restrictimports.analyze.BannedImportGroup;
import de.skuzzle.enforcer.restrictimports.analyze.BannedImportGroups;
import de.skuzzle.enforcer.restrictimports.analyze.NotFixable;
import de.skuzzle.enforcer.restrictimports.analyze.PackagePattern;
import de.skuzzle.enforcer.restrictimports.analyze.SourceTreeAnalyzer;
import de.skuzzle.enforcer.restrictimports.formatting.MatchFormatter;
import de.skuzzle.enforcer.restrictimports.util.Preconditions;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.enforcer.rule.api.EnforcerLevel;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRule2;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugins.enforcer.BannedImportGroupDefinition;
import org.apache.maven.plugins.enforcer.BannedImportGroupDefinitionInterface;
import org.apache.maven.plugins.enforcer.NotFixableDefinition;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestrictImports
implements EnforcerRule,
EnforcerRule2,
BannedImportGroupDefinitionInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestrictImports.class);
    private static final String SKIP_PROPERTY_NAME = "restrictimports.skip";
    private static final String FAIL_BUILD_PROPERTY_NAME = "restrictimports.failBuild";
    private static final String PARALLEL_ANALYSIS_PROPERTY_NAME = "restrictimports.parallel";
    private final SourceTreeAnalyzer analyzer = SourceTreeAnalyzer.getInstance();
    private final MatchFormatter matchFormatter = MatchFormatter.getInstance();
    private final BannedImportGroupDefinition group = new BannedImportGroupDefinition();
    private List<BannedImportGroupDefinition> groups = new ArrayList<BannedImportGroupDefinition>();
    private NotFixableDefinition notFixable = null;
    private List<NotFixableDefinition> notFixables = new ArrayList<NotFixableDefinition>();
    private boolean includeCompileCode = true;
    private boolean includeTestCode = true;
    private File excludedSourceRoot = null;
    private List<File> excludedSourceRoots = new ArrayList<File>();
    private boolean failBuild = true;
    private boolean skip = false;
    private boolean parallel = true;
    private boolean parseFullCompilationUnit = false;

    public EnforcerLevel getLevel() {
        return this.failBuild ? EnforcerLevel.ERROR : EnforcerLevel.WARN;
    }

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        try {
            if (this.isSkip(helper)) {
                LOGGER.info("restrict-imports-enforcer rule is skipped");
                return;
            }
            MavenProject project = (MavenProject)helper.evaluate("${project}");
            LOGGER.debug("Checking for banned imports");
            BannedImportGroups groups = this.createGroupsFromPluginConfiguration();
            LOGGER.debug("Banned import groups:\n{}", (Object)groups);
            AnalyzerSettings analyzerSettings = this.createAnalyzerSettingsFromPluginConfiguration(helper, project);
            LOGGER.debug("Analyzer settings:\n{}", (Object)analyzerSettings);
            AnalyzeResult analyzeResult = this.analyzer.analyze(analyzerSettings, groups);
            LOGGER.debug("Analyzer result:\n{}", (Object)analyzeResult);
            if (analyzeResult.bannedImportsOrWarningsFound()) {
                String errorMessage = this.matchFormatter.formatMatches(analyzerSettings.getAllDirectories(), analyzeResult);
                if (analyzeResult.bannedImportsFound() && this.isFailBuild(helper)) {
                    throw new EnforcerRuleException(errorMessage);
                }
                LOGGER.warn(errorMessage);
                LOGGER.warn("Detected banned imports will not fail the build as the 'failBuild' flag is set to false!");
            } else {
                LOGGER.debug("No banned imports found");
            }
        }
        catch (BannedImportDefinitionException e) {
            throw new EnforcerRuleException("RestrictImports rule configuration error: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (RuntimeException | EnforcerRuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Encountered unexpected exception: " + e.getLocalizedMessage(), e);
        }
    }

    private BannedImportGroups createGroupsFromPluginConfiguration() {
        Stream<NotFixableDefinition> notFixableDefinitions = this.notFixable != null ? Stream.of(this.notFixable) : this.notFixables.stream();
        List<NotFixable> globalNotFixables = notFixableDefinitions.map(notFixable -> NotFixable.of((PackagePattern)PackagePattern.parse((String)notFixable.getIn()), (List)PackagePattern.parseAll(notFixable.getAllowedImport()))).collect(Collectors.toList());
        if (!this.groups.isEmpty()) {
            List bannedImportGroups = this.groups.stream().map(group -> group.createGroupFromPluginConfiguration(globalNotFixables)).collect(Collectors.toList());
            return BannedImportGroups.builder().withGroups(bannedImportGroups).build();
        }
        BannedImportGroup singleGroup = this.group.createGroupFromPluginConfiguration(globalNotFixables);
        return BannedImportGroups.builder().withGroup(singleGroup).build();
    }

    private AnalyzerSettings createAnalyzerSettingsFromPluginConfiguration(EnforcerRuleHelper helper, MavenProject mavenProject) throws Exception {
        if (!this.includeCompileCode && !this.includeTestCode) {
            throw new IllegalArgumentException("Configuration error: No sources were included");
        }
        List<Path> excludedSourceRootsAbsolutePaths = this.excludedSourceRootsAbsolutePaths();
        List srcDirectories = this.includeCompileCode ? this.listSourceRoots(mavenProject.getCompileSourceRoots(), excludedSourceRootsAbsolutePaths) : Collections.emptyList();
        List testDirectories = this.includeTestCode ? this.listSourceRoots(mavenProject.getTestCompileSourceRoots(), excludedSourceRootsAbsolutePaths) : Collections.emptyList();
        Charset sourceFileCharset = this.determineSourceFileCharset(mavenProject);
        boolean parallel = this.isParallel(helper);
        boolean parseFullCompilationUnit = this.parseFullCompilationUnit;
        return AnalyzerSettings.builder().withSrcDirectories(srcDirectories).withTestDirectories(testDirectories).withSourceFileCharset(sourceFileCharset).enableParallelAnalysis(parallel).withParseFullCompilationUnit(parseFullCompilationUnit).build();
    }

    private List<Path> excludedSourceRootsAbsolutePaths() {
        List<File> excludedSourceRoots = this.excludedSourceRoot != null ? Collections.singletonList(this.excludedSourceRoot) : this.excludedSourceRoots;
        return excludedSourceRoots.stream().map(sourceRoot -> sourceRoot.getAbsoluteFile().toPath()).collect(Collectors.toList());
    }

    private Charset determineSourceFileCharset(MavenProject mavenProject) {
        String mavenCharsetName = (String)mavenProject.getProperties().get("project.build.sourceEncoding");
        if (mavenCharsetName != null) {
            return Charset.forName(mavenCharsetName);
        }
        return Charset.defaultCharset();
    }

    private Collection<Path> listSourceRoots(Collection<String> pathNames, Collection<Path> excludedSourceRootsAbsolutePaths) {
        return pathNames.stream().peek(pathName -> LOGGER.debug("Including source dir: {}", pathName)).map(x$0 -> Paths.get(x$0, new String[0])).filter(path -> this.include((Path)path, excludedSourceRootsAbsolutePaths)).collect(Collectors.toList());
    }

    private boolean include(Path path, Collection<Path> excludedSourceRootsAbsolutePaths) {
        boolean exclude = excludedSourceRootsAbsolutePaths.contains(path);
        if (exclude) {
            LOGGER.debug("Excluding source dir: {} according to excludedSourceRoots", (Object)path);
            return false;
        }
        return true;
    }

    private void checkGroups(boolean condition) {
        if (!condition) {
            throw new IllegalArgumentException("Configuration error: you can either define a list of banned import definitions using <groups> OR define a single banned import definition on top level without <groups> but not both");
        }
    }

    public void setParseFullCompilationUnit(boolean parseFullCompilationUnit) {
        this.parseFullCompilationUnit = parseFullCompilationUnit;
    }

    @Override
    public void setBasePackage(String basePackage) {
        this.checkGroups(this.groups.isEmpty());
        this.group.setBasePackage(basePackage);
    }

    @Override
    public void setBasePackages(List<String> basePackages) {
        this.checkGroups(this.groups.isEmpty());
        this.group.setBasePackages(basePackages);
    }

    @Override
    public void setBannedImport(String bannedImport) {
        this.checkGroups(this.groups.isEmpty());
        this.group.setBannedImport(bannedImport);
    }

    @Override
    public void setBannedImports(List<String> bannedPackages) {
        this.checkGroups(this.groups.isEmpty());
        this.group.setBannedImports(bannedPackages);
    }

    @Override
    public void setAllowedImport(String allowedImport) {
        this.checkGroups(this.groups.isEmpty());
        this.group.setAllowedImport(allowedImport);
    }

    @Override
    public void setAllowedImports(List<String> allowedImports) {
        this.checkGroups(this.groups.isEmpty());
        this.group.setAllowedImports(allowedImports);
    }

    @Override
    public void setExclusion(String exclusion) {
        this.checkGroups(this.groups.isEmpty());
        this.group.setExclusion(exclusion);
    }

    @Override
    public void setExclusions(List<String> exclusions) {
        this.checkGroups(this.groups.isEmpty());
        this.group.setExclusions(exclusions);
    }

    @Override
    public void setReason(String reason) {
        this.checkGroups(this.groups.isEmpty());
        this.group.setReason(reason);
    }

    public void setGroups(List<BannedImportGroupDefinition> groups) {
        this.checkGroups(!this.group.hasInput());
        Preconditions.checkArgument((groups != null && !groups.isEmpty() ? 1 : 0) != 0, (String)"Groups may not be empty", (Object[])new Object[0]);
        this.groups = groups;
    }

    public final void setIncludeCompileCode(boolean includeCompileCode) {
        this.includeCompileCode = includeCompileCode;
    }

    public final void setIncludeTestCode(boolean includeTestCode) {
        this.includeTestCode = includeTestCode;
    }

    public final void setExcludedSourceRoot(File excludedSourceRoot) {
        Preconditions.checkArgument((boolean)this.excludedSourceRoots.isEmpty(), (String)"Configuration error: you should either specify a single excluded source root using <excludedSourceRoot> or multiple excluded source roots using <excludedSourceRoots> but not both", (Object[])new Object[0]);
        Preconditions.checkArgument((this.excludedSourceRoot == null ? 1 : 0) != 0, (String)"If you want to specify multiple excluded source root you have to wrap them in a <excludedSourceRoots> tag", (Object[])new Object[0]);
        this.excludedSourceRoot = excludedSourceRoot;
    }

    public final void setExcludedSourceRoots(List<File> excludedSourceRoots) {
        Preconditions.checkArgument((this.excludedSourceRoot == null ? 1 : 0) != 0, (String)"Configuration error: you should either specify a single excluded source root using <excludedSourceRoot> or multiple excluded source roots using <excludedSourceRoots> but not both", (Object[])new Object[0]);
        this.excludedSourceRoots = excludedSourceRoots;
    }

    public void setNotFixable(NotFixableDefinition notFixable) {
        Preconditions.checkArgument((boolean)this.notFixables.isEmpty(), (String)"Configuration error: you should either specify a single not-fixable entry using <notFixable> or multiple entries using <notFixables> but not both", (Object[])new Object[0]);
        this.notFixable = notFixable;
    }

    public final void setNotFixables(List<NotFixableDefinition> notFixables) {
        Preconditions.checkArgument((this.notFixable == null ? 1 : 0) != 0, (String)"Configuration error: you should either specify a single not-fixable entry using <notFixable> or multiple entries using <notFixables> but not both", (Object[])new Object[0]);
        Preconditions.checkArgument((!notFixables.isEmpty() ? 1 : 0) != 0, (String)"Not fixable list must not be empty", (Object[])new Object[0]);
        this.notFixables = notFixables;
    }

    public void setFailBuild(boolean failBuild) {
        this.failBuild = failBuild;
    }

    private boolean isFailBuild(EnforcerRuleHelper evaluator) throws Exception {
        Object failBuildProperty = evaluator.evaluate("${restrictimports.failBuild}");
        if (failBuildProperty != null) {
            LOGGER.warn("'{}={}' has been passed which takes precedence over 'failBuild={}' configuration in the pom file", new Object[]{FAIL_BUILD_PROPERTY_NAME, failBuildProperty, this.failBuild});
            return "true".equalsIgnoreCase(failBuildProperty.toString());
        }
        return this.failBuild;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    private boolean isSkip(EnforcerRuleHelper evaluator) throws Exception {
        Object skipProperty = evaluator.evaluate("${restrictimports.skip}");
        if (skipProperty != null) {
            LOGGER.warn("'{}={}' has been passed which takes precedence over 'skip={}' configuration in the pom file", new Object[]{SKIP_PROPERTY_NAME, skipProperty, this.skip});
            return "true".equalsIgnoreCase(skipProperty.toString());
        }
        return this.skip;
    }

    public void setParallel(boolean parallel) {
        this.parallel = parallel;
    }

    private boolean isParallel(EnforcerRuleHelper evaluator) throws Exception {
        Object parallelProperty = evaluator.evaluate("${restrictimports.parallel}");
        if (parallelProperty != null) {
            LOGGER.warn("'{}={}' has been passed which takes precedence over 'parallel={}' configuration in the pom file", new Object[]{PARALLEL_ANALYSIS_PROPERTY_NAME, parallelProperty, this.parallel});
            return "true".equalsIgnoreCase(parallelProperty.toString());
        }
        return this.parallel;
    }

    public String getCacheId() {
        return "";
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule rule) {
        return false;
    }
}

