/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports.impl;

import de.skuzzle.enforcer.restrictimports.BannedImportGroup;
import de.skuzzle.enforcer.restrictimports.IOUtils;
import de.skuzzle.enforcer.restrictimports.Match;
import de.skuzzle.enforcer.restrictimports.SourceTreeAnalyzer;
import de.skuzzle.enforcer.restrictimports.impl.ImportMatcher;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class SourceTreeAnalyzerImpl
implements SourceTreeAnalyzer {
    private final ImportMatcher matcher;
    private final IOUtils ioUtil;

    public SourceTreeAnalyzerImpl(ImportMatcher matcher, IOUtils ioUtils) {
        this.matcher = matcher;
        this.ioUtil = ioUtils;
    }

    @Override
    public Map<String, List<Match>> analyze(Stream<Path> roots, BannedImportGroup group) {
        return roots.flatMap(root -> this.ioUtil.listFiles((Path)root, this::isJavaSourceFile)).flatMap(path -> this.matcher.matchFile((Path)path, group)).collect(Collectors.groupingBy(Match::getSourceFile));
    }

    private boolean isJavaSourceFile(Path path) {
        return this.ioUtil.isFile(path) && path.getFileName().toString().toLowerCase().endsWith(".java");
    }
}

