/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports.impl;

import de.skuzzle.enforcer.restrictimports.PackagePattern;
import java.util.Arrays;
import java.util.stream.Collectors;

public final class PackagePatternImpl
implements PackagePattern {
    private final String[] parts;

    public PackagePatternImpl(String s) {
        this.parts = s.split("\\.");
        for (int i = 0; i < this.parts.length; ++i) {
            boolean last;
            boolean bl = last = i == this.parts.length - 1;
            if (last || !"**".equals(this.parts[i])) continue;
            throw new IllegalArgumentException("Double wildcard '**' only allowed at end of pattern");
        }
    }

    @Override
    public boolean matches(String packageName) {
        String[] matchParts = packageName.split("\\.");
        int count = Math.min(matchParts.length, this.parts.length);
        for (int i = 0; i < count; ++i) {
            String patternPart = this.parts[i];
            String matchPart = matchParts[i];
            if (PackagePatternImpl.matchParts(patternPart, matchPart)) continue;
            return false;
        }
        if (this.parts.length == matchParts.length) {
            return true;
        }
        if (this.parts.length > matchParts.length) {
            return false;
        }
        return "**".equals(this.parts[this.parts.length - 1]);
    }

    private static boolean matchParts(String patternPart, String matchPart) {
        if ("*".equals(patternPart) || "**".equals(patternPart)) {
            return true;
        }
        return patternPart.equals(matchPart);
    }

    public String toString() {
        return Arrays.stream(this.parts).collect(Collectors.joining("."));
    }

    public int hashCode() {
        return Arrays.hashCode(this.parts);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof PackagePatternImpl && Arrays.equals(this.parts, ((PackagePatternImpl)obj).parts);
    }
}

