/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports.impl;

import de.skuzzle.enforcer.restrictimports.IOUtils;
import de.skuzzle.enforcer.restrictimports.impl.RuntimeIOException;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class IOUtilsImpl
implements IOUtils {
    @Override
    public Stream<String> lines(Path path) throws RuntimeIOException {
        try {
            return Files.lines(path);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public Stream<Path> listFiles(Path root, Predicate<Path> filter) {
        try {
            if (!Files.exists(root, new LinkOption[0])) {
                return Stream.empty();
            }
            return Files.find(root, Integer.MAX_VALUE, (path, bfa) -> filter.test((Path)path), new FileVisitOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public boolean isFile(Path path) {
        return !Files.isDirectory(path, new LinkOption[0]);
    }
}

