/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports;

import com.google.common.base.Preconditions;
import de.skuzzle.enforcer.restrictimports.BannedImportGroup;
import de.skuzzle.enforcer.restrictimports.Match;
import de.skuzzle.enforcer.restrictimports.PackagePattern;
import de.skuzzle.enforcer.restrictimports.SourceTreeAnalyzer;
import de.skuzzle.enforcer.restrictimports.impl.DefaultAnalyzerFactory;
import de.skuzzle.enforcer.restrictimports.impl.RuntimeIOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;

public class RestrictImports
implements EnforcerRule {
    private PackagePattern basePackage = PackagePattern.parse("**");
    private List<PackagePattern> bannedImports = new ArrayList<PackagePattern>();
    private List<PackagePattern> allowedImports = new ArrayList<PackagePattern>();
    private List<PackagePattern> excludedClasses = new ArrayList<PackagePattern>();
    private boolean includeTestCode;
    private static final SourceTreeAnalyzer ANALYZER = DefaultAnalyzerFactory.getInstance().createAnalyzer();

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        Log log = helper.getLog();
        try {
            MavenProject project = (MavenProject)helper.evaluate("${project}");
            log.debug((CharSequence)"Checking for banned imports");
            BannedImportGroup group = new BannedImportGroup(this.basePackage, this.bannedImports, this.allowedImports, this.excludedClasses);
            Map<String, List<Match>> matches = ANALYZER.analyze(this.listSourceRoots(project, log), group);
            if (!matches.isEmpty()) {
                List roots = project.getCompileSourceRoots();
                throw new EnforcerRuleException(this.formatErrorString(roots, matches));
            }
            log.debug((CharSequence)"No banned imports found");
        }
        catch (RuntimeIOException e) {
            throw new EnforcerRuleException("Encountered IO exception", (Exception)e);
        }
        catch (ExpressionEvaluationException e) {
            throw new EnforcerRuleException("Unable to lookup an expression " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
    }

    private static String relativize(Collection<String> roots, String path) {
        for (String root : roots) {
            if (!path.startsWith(root)) continue;
            return path.substring(root.length());
        }
        return path;
    }

    private String formatErrorString(Collection<String> roots, Map<String, List<Match>> groups) {
        StringBuilder b = new StringBuilder("\nBanned imports detected:\n");
        groups.forEach((fileName, matches) -> {
            b.append("\tin file: ").append(RestrictImports.relativize(roots, fileName)).append("\n");
            matches.forEach(match -> b.append("\t\t").append(match.getMatchedString()).append(" (Line: ").append(match.getImportLine()).append(")\n"));
        });
        return b.toString();
    }

    private Stream<Path> listSourceRoots(MavenProject project, Log log) {
        Stream rootFolders;
        Stream compileStream = project.getCompileSourceRoots().stream();
        if (this.includeTestCode) {
            Stream testStream = project.getTestCompileSourceRoots().stream();
            rootFolders = Stream.concat(compileStream, testStream);
        } else {
            rootFolders = compileStream;
        }
        return rootFolders.peek(root -> log.debug((CharSequence)("Including source dir: " + root))).map(x$0 -> Paths.get(x$0, new String[0]));
    }

    public String getCacheId() {
        return "";
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule rule) {
        return false;
    }

    public final void setBasePackage(String basePackage) {
        this.basePackage = PackagePattern.parse(basePackage);
    }

    public final void setBannedImports(List<String> bannedPackages) {
        Preconditions.checkArgument((bannedPackages != null && !bannedPackages.isEmpty() ? 1 : 0) != 0, (Object)"bannedPackages must not be empty");
        this.bannedImports = PackagePattern.parseAll(bannedPackages);
    }

    public final void setAllowedImports(List<String> allowedImports) {
        this.allowedImports = PackagePattern.parseAll(allowedImports);
    }

    public final void setExcludedClasses(List<String> excludedClasses) {
        this.excludedClasses = PackagePattern.parseAll(excludedClasses);
    }

    public void setIncludeTestCode(boolean includeTestCode) {
        this.includeTestCode = includeTestCode;
    }
}

