/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports.impl;

import de.skuzzle.enforcer.restrictimports.BannedImportGroup;
import de.skuzzle.enforcer.restrictimports.ImportMatcher;
import de.skuzzle.enforcer.restrictimports.Match;
import de.skuzzle.enforcer.restrictimports.PackagePattern;
import de.skuzzle.enforcer.restrictimports.impl.RuntimeIOException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class ImportMatcherImpl
implements ImportMatcher {
    private final LineSupplier supplier;

    ImportMatcherImpl(LineSupplier supplier) {
        this.supplier = supplier;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Stream<Match> matchFile(Path file, BannedImportGroup group) {
        LineCounter counter = new LineCounter();
        PackageExtractor packageExtractor = new PackageExtractor();
        try (Stream<String> lines = this.supplier.lines(file);){
            Stream<Match> stream = lines.map(String::trim).peek(counter).peek(packageExtractor).filter(ImportMatcherImpl::isImport).peek(ImportMatcherImpl.includeClass(file, packageExtractor, group)).map(ImportMatcherImpl::extractPackageName).filter(ImportMatcherImpl.matchesAnyPattern(group.getBannedImports())).filter(ImportMatcherImpl.matchesAnyPattern(group.getAllowedImports()).negate()).map(ImportMatcherImpl.toMatch(counter::getLine, file.toString())).collect(Collectors.toList()).stream();
            return stream;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        catch (PrematureAbortion ignore) {
            return Stream.empty();
        }
    }

    private static Consumer<String> includeClass(Path file, PackageExtractor extractor, BannedImportGroup group) {
        return line -> {
            String javaFileName = ImportMatcherImpl.getJavaFileName(file);
            String javaResource = extractor.getPackageName() + "." + javaFileName;
            if (!group.getBasePackage().matches(javaResource)) {
                throw new PrematureAbortion();
            }
            boolean isExcluded = group.getExcludedClasses().stream().anyMatch(pattern -> pattern.matches(javaResource));
            if (isExcluded) {
                throw new PrematureAbortion();
            }
        };
    }

    private static String getJavaFileName(Path file) {
        String s = file.getFileName().toString();
        int i = s.lastIndexOf(".java");
        return s.substring(0, i);
    }

    private static Predicate<String> matchesAnyPattern(Collection<PackagePattern> patterns) {
        return packageName -> patterns.stream().anyMatch(pattern -> pattern.matches((String)packageName));
    }

    private static Function<String, Match> toMatch(Supplier<Integer> lineGetter, String filePath) {
        return matchedImport -> new Match(filePath, (Integer)lineGetter.get(), (String)matchedImport);
    }

    private static String extractPackageName(String line) {
        int spaceIdx = line.indexOf(" ");
        int semiIdx = line.indexOf(";");
        String sub = line.substring(spaceIdx, semiIdx);
        return sub.trim();
    }

    private static boolean is(String compare, String line) {
        return line.startsWith(compare) && line.endsWith(";");
    }

    private static boolean isPackage(String line) {
        return ImportMatcherImpl.is("package", line);
    }

    private static boolean isImport(String line) {
        return ImportMatcherImpl.is("import", line);
    }

    private static class PrematureAbortion
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private PrematureAbortion() {
        }
    }

    private static class PackageExtractor
    implements Consumer<String> {
        private String packageName = "";

        private PackageExtractor() {
        }

        @Override
        public void accept(String line) {
            if (ImportMatcherImpl.isPackage(line)) {
                this.packageName = ImportMatcherImpl.extractPackageName(line);
            }
        }

        public String getPackageName() {
            return this.packageName;
        }
    }

    private static class LineCounter
    implements Consumer<String> {
        private int line = 0;

        private LineCounter() {
        }

        @Override
        public void accept(String t) {
            ++this.line;
        }

        public int getLine() {
            return this.line;
        }
    }

    public static interface LineSupplier {
        public Stream<String> lines(Path var1) throws IOException;
    }
}

