/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports;

import com.google.common.base.Preconditions;
import de.skuzzle.enforcer.restrictimports.PackagePattern;
import java.util.ArrayList;
import java.util.List;

public class BannedImportGroup {
    private PackagePattern basePackage = PackagePattern.parse("**");
    private List<PackagePattern> bannedImports = new ArrayList<PackagePattern>();
    private List<PackagePattern> allowedImports = new ArrayList<PackagePattern>();
    private List<PackagePattern> excludedClasses = new ArrayList<PackagePattern>();

    public final PackagePattern getBasePackage() {
        return this.basePackage;
    }

    public final void setBasePackage(String basePackage) {
        this.basePackage = PackagePattern.parse(basePackage);
    }

    public final List<PackagePattern> getBannedImports() {
        return this.bannedImports;
    }

    public final void setBannedImports(List<String> bannedPackages) {
        Preconditions.checkArgument((bannedPackages != null && !bannedPackages.isEmpty() ? 1 : 0) != 0, (Object)"bannedPackages must not be empty");
        this.bannedImports = PackagePattern.parseAll(bannedPackages);
    }

    public final List<PackagePattern> getAllowedImports() {
        return this.allowedImports;
    }

    public final void setAllowedImports(List<String> allowedImports) {
        this.allowedImports = PackagePattern.parseAll(allowedImports);
    }

    public final List<PackagePattern> getExcludedClasses() {
        return this.excludedClasses;
    }

    public final void setExcludedClasses(List<String> excludedClasses) {
        this.excludedClasses = PackagePattern.parseAll(excludedClasses);
    }
}

