/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports;

import de.skuzzle.enforcer.restrictimports.ImportMatcher;
import de.skuzzle.enforcer.restrictimports.ImportMatcherImpl;
import de.skuzzle.enforcer.restrictimports.Match;
import de.skuzzle.enforcer.restrictimports.PackagePattern;
import de.skuzzle.enforcer.restrictimports.RuntimeIOException;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;

public class RestrictImports
implements EnforcerRule {
    private List<String> bannedImports = new ArrayList<String>();
    private List<String> allowedImports = new ArrayList<String>();
    private final ImportMatcher matcher = new ImportMatcherImpl();

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        Log log = helper.getLog();
        try {
            MavenProject project = (MavenProject)helper.evaluate("${project}");
            List<PackagePattern> bannedPatterns = this.compile(this.bannedImports);
            List<PackagePattern> allowedPatterns = this.compile(this.allowedImports);
            if (bannedPatterns.isEmpty()) {
                log.info((CharSequence)"No banned imports have been specified");
                return;
            }
            log.debug((CharSequence)"Checking for banned imports");
            Map<String, List<Match>> matches = this.listSourceFiles(project, log).peek(sourceFile -> log.debug((CharSequence)("Analyzing '" + sourceFile.toString() + "' for banned imports"))).flatMap(this.matchFile(bannedPatterns, allowedPatterns)).collect(Collectors.groupingBy(Match::getSourceFile));
            if (!matches.isEmpty()) {
                List roots = project.getCompileSourceRoots();
                throw new EnforcerRuleException(this.formatErrorString(roots, matches));
            }
            log.debug((CharSequence)"No banned imports found");
        }
        catch (RuntimeIOException e) {
            throw new EnforcerRuleException("Encountered IO exception", (Exception)e);
        }
        catch (ExpressionEvaluationException e) {
            throw new EnforcerRuleException("Unable to lookup an expression " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
    }

    private String relativize(Collection<String> roots, String path) {
        for (String root : roots) {
            if (!path.startsWith(root)) continue;
            return path.substring(root.length());
        }
        return path;
    }

    private String formatErrorString(Collection<String> roots, Map<String, List<Match>> groups) {
        StringBuilder b = new StringBuilder("\nBanned imports detected:\n");
        groups.forEach((fileName, matches) -> {
            b.append("\tin file: ").append(this.relativize(roots, (String)fileName)).append("\n");
            matches.forEach(match -> b.append("\t\t").append(match.getMatchedString()).append(" (Line: ").append(match.getImportLine()).append(")\n"));
        });
        return b.toString();
    }

    private Function<Path, Stream<Match>> matchFile(Collection<PackagePattern> banned, Collection<PackagePattern> allowed) {
        return sourceFile -> this.matcher.matchFile((Path)sourceFile, banned, allowed);
    }

    private static boolean isJavaSourceFile(Path path, BasicFileAttributes bfa) {
        return !Files.isDirectory(path, new LinkOption[0]) && path.getFileName().toString().toLowerCase().endsWith(".java");
    }

    private static Stream<Path> listFiles(Path dir) {
        try {
            return Files.find(dir, Integer.MAX_VALUE, RestrictImports::isJavaSourceFile, new FileVisitOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private Stream<Path> listSourceFiles(MavenProject project, Log log) {
        List roots = project.getCompileSourceRoots();
        return roots.stream().peek(root -> log.debug((CharSequence)("Including source dir: " + root))).map(x$0 -> Paths.get(x$0, new String[0])).flatMap(RestrictImports::listFiles);
    }

    private List<PackagePattern> compile(List<String> patterns) {
        return patterns.stream().map(PackagePattern::parse).collect(Collectors.toList());
    }

    public String getCacheId() {
        return "";
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule rule) {
        return false;
    }

    public void setAllowedImports(List<String> allowedImports) {
        this.allowedImports = allowedImports;
    }

    public void setBannedImports(List<String> bannedImports) {
        this.bannedImports = bannedImports;
    }
}

