/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports;

import com.google.common.annotations.VisibleForTesting;
import de.skuzzle.enforcer.restrictimports.ImportMatcher;
import de.skuzzle.enforcer.restrictimports.Match;
import de.skuzzle.enforcer.restrictimports.PackagePattern;
import de.skuzzle.enforcer.restrictimports.RuntimeIOException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class ImportMatcherImpl
implements ImportMatcher {
    private final LineSupplier supplier;

    ImportMatcherImpl() {
        this(Files::lines);
    }

    @VisibleForTesting
    ImportMatcherImpl(LineSupplier supplier) {
        this.supplier = supplier;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Stream<Match> matchFile(Path file, Collection<PackagePattern> bannedImports, Collection<PackagePattern> allowed) {
        LineCounter counter = new LineCounter();
        try (Stream<String> lines = this.supplier.lines(file);){
            Stream<Match> stream = lines.map(String::trim).peek(counter).filter(ImportMatcherImpl::isImport).map(ImportMatcherImpl::extractPackage).filter(ImportMatcherImpl.matchesAnyPattern(bannedImports)).filter(ImportMatcherImpl.not(ImportMatcherImpl.matchesAnyPattern(allowed))).map(ImportMatcherImpl.toMatch(counter::getLine, file.toString())).collect(Collectors.toList()).stream();
            return stream;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private static <T> Predicate<T> not(Predicate<T> predicate) {
        return t -> !predicate.test(t);
    }

    private static Predicate<String> matchesAnyPattern(Collection<PackagePattern> patterns) {
        return packageName -> patterns.stream().anyMatch(pattern -> pattern.matches((String)packageName));
    }

    private static Function<String, Match> toMatch(Supplier<Integer> lineGetter, String filePath) {
        return matchedImport -> new Match(filePath, (Integer)lineGetter.get(), (String)matchedImport);
    }

    private static String extractPackage(String line) {
        int spaceIdx = line.indexOf(" ");
        int semiIdx = line.indexOf(";");
        String sub = line.substring(spaceIdx, semiIdx);
        return sub.trim();
    }

    private static boolean isImport(String line) {
        return line.startsWith("import") && line.endsWith(";");
    }

    private static class LineCounter
    implements Consumer<String> {
        private int line = 0;

        private LineCounter() {
        }

        @Override
        public void accept(String t) {
            ++this.line;
        }

        public int getLine() {
            return this.line;
        }
    }

    public static interface LineSupplier {
        public Stream<String> lines(Path var1) throws IOException;
    }
}

