/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports;

import de.skuzzle.enforcer.restrictimports.PackagePattern;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PackagePatternImplTest {
    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void testMatchExactly() throws Exception {
        PackagePattern pattern = PackagePattern.parse((String)"de.skuzzle.SomeClass");
        Assert.assertTrue((boolean)pattern.matches("de.skuzzle.SomeClass"));
        Assert.assertFalse((boolean)pattern.matches("de.skuzzle.SomeClass2"));
    }

    @Test
    public void testMatchWildCardSuffix() throws Exception {
        PackagePattern pattern = PackagePattern.parse((String)"de.skuzzle.*");
        Assert.assertTrue((boolean)pattern.matches("de.skuzzle.TestClass"));
        Assert.assertTrue((boolean)pattern.matches("de.skuzzle.TestClass2"));
    }

    @Test
    public void testWildCardMatchesSingle() throws Exception {
        PackagePattern pattern = PackagePattern.parse((String)"de.skuzzle.*");
        Assert.assertFalse((boolean)pattern.matches("de.skuzzle.sub.TestClass"));
    }

    @Test
    public void testMatchInfix() throws Exception {
        PackagePattern pattern = PackagePattern.parse((String)"de.skuzzle.*.test");
        Assert.assertTrue((boolean)pattern.matches("de.skuzzle.foo.test"));
        Assert.assertFalse((boolean)pattern.matches("de.skuzzle.test"));
    }

    @Test
    public void testWildCatMatchMultiple() throws Exception {
        PackagePattern pattern = PackagePattern.parse((String)"de.skuzzle.**");
        Assert.assertTrue((boolean)pattern.matches("de.skuzzle.sub.TestClass"));
        Assert.assertTrue((boolean)pattern.matches("de.skuzzle.TestClass2"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWildCardNoSuffix() throws Exception {
        PackagePattern.parse((String)"de.skuzzle.**.test");
    }

    @Test
    public void testLogger() throws Exception {
        PackagePattern pattern = PackagePattern.parse((String)"java.util.**");
        Assert.assertTrue((boolean)pattern.matches("java.util.logging.Logger"));
    }
}

