/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports;

import com.google.common.collect.ImmutableList;
import de.skuzzle.enforcer.restrictimports.ImportMatcherImpl;
import de.skuzzle.enforcer.restrictimports.Match;
import de.skuzzle.enforcer.restrictimports.PackagePattern;
import de.skuzzle.enforcer.restrictimports.RuntimeIOException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ImportMatcherImplTest {
    @Mock
    private ImportMatcherImpl.LineSupplier mockLineSupplier;
    @InjectMocks
    private ImportMatcherImpl subject;
    private final Path path = (Path)Mockito.mock(Path.class);

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.path.toString()).thenReturn((Object)"path/to/file");
        Mockito.when((Object)this.mockLineSupplier.lines(this.path)).thenReturn((Object)ImmutableList.of((Object)"package de.skuzzle.test;", (Object)"", (Object)"import de.skuzzle.sample.Test;", (Object)"import   foo.bar.xyz;", (Object)"import de.skuzzle.sample.Test2;", (Object)"import de.foo.bar.Test").stream());
    }

    @Test(expected=RuntimeIOException.class)
    public void testException() throws Exception {
        Mockito.when((Object)this.mockLineSupplier.lines(this.path)).thenThrow(new Throwable[]{new IOException()});
        this.subject.matchFile(this.path, (Collection)ImmutableList.of(), (Collection)ImmutableList.of()).collect(Collectors.toList());
    }

    @Test
    public void testMatchBannedOnly() throws Exception {
        ImmutableList banned = ImmutableList.of((Object)PackagePattern.parse((String)"de.skuzzle.sample.*"));
        List matches = this.subject.matchFile(this.path, (Collection)banned, (Collection)ImmutableList.of()).collect(Collectors.toList());
        Assert.assertEquals((long)2L, (long)matches.size());
        Match match1 = (Match)matches.get(0);
        Assert.assertEquals((Object)"de.skuzzle.sample.Test", (Object)match1.getMatchedString());
        Assert.assertEquals((long)3L, (long)match1.getImportLine());
        Assert.assertEquals((Object)"path/to/file", (Object)match1.getSourceFile());
        Match match2 = (Match)matches.get(1);
        Assert.assertEquals((long)5L, (long)match2.getImportLine());
        Assert.assertEquals((Object)"de.skuzzle.sample.Test2", (Object)match2.getMatchedString());
        Assert.assertEquals((Object)"path/to/file", (Object)match2.getSourceFile());
    }

    @Test
    public void testMatchWithInclude() throws Exception {
        ImmutableList banned = ImmutableList.of((Object)PackagePattern.parse((String)"de.skuzzle.sample.*"));
        ImmutableList include = ImmutableList.of((Object)PackagePattern.parse((String)"de.skuzzle.sample.Test2"));
        List matches = this.subject.matchFile(this.path, (Collection)banned, (Collection)include).collect(Collectors.toList());
        Assert.assertEquals((long)1L, (long)matches.size());
        Match match1 = (Match)matches.get(0);
        Assert.assertEquals((Object)"de.skuzzle.sample.Test", (Object)match1.getMatchedString());
        Assert.assertEquals((long)3L, (long)match1.getImportLine());
        Assert.assertEquals((Object)"path/to/file", (Object)match1.getSourceFile());
    }
}

