/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports.rule;

import com.google.common.base.Preconditions;
import de.skuzzle.enforcer.restrictimports.analyze.AnalyzeResult;
import de.skuzzle.enforcer.restrictimports.analyze.AnalyzerSettings;
import de.skuzzle.enforcer.restrictimports.analyze.BannedImportDefinitionException;
import de.skuzzle.enforcer.restrictimports.analyze.BannedImportGroup;
import de.skuzzle.enforcer.restrictimports.analyze.BannedImportGroups;
import de.skuzzle.enforcer.restrictimports.analyze.SourceTreeAnalyzer;
import de.skuzzle.enforcer.restrictimports.formatting.MatchFormatter;
import de.skuzzle.enforcer.restrictimports.io.RuntimeIOException;
import de.skuzzle.enforcer.restrictimports.rule.BannedImportGroupDefinition;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestrictImports
extends BannedImportGroupDefinition
implements EnforcerRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestrictImports.class);
    private List<BannedImportGroupDefinition> groups = new ArrayList<BannedImportGroupDefinition>();
    private boolean includeTestCode = false;
    private boolean failBuild = true;
    private boolean skip = false;

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        if (this.skip) {
            LOGGER.info("restrict-imports-enforcer rule is skipped");
            return;
        }
        try {
            MavenProject project = (MavenProject)helper.evaluate("${project}");
            LOGGER.debug("Checking for banned imports");
            BannedImportGroups groups = this.assembleGroups();
            LOGGER.debug("Banned import groups:\n{}", (Object)groups);
            AnalyzerSettings analyzerSettings = this.createAnalyzerSettingsFromPluginConfiguration(project);
            LOGGER.debug("Analyzer settings:\n{}", (Object)analyzerSettings);
            AnalyzeResult analyzeResult = SourceTreeAnalyzer.getInstance().analyze(analyzerSettings, groups);
            LOGGER.debug("Analyzer result:\n{}", (Object)analyzeResult);
            if (analyzeResult.bannedImportsFound()) {
                String errorMessage = MatchFormatter.getInstance().formatMatches(analyzerSettings.getAllDirectories(), analyzeResult);
                if (this.failBuild) {
                    throw new EnforcerRuleException(errorMessage);
                }
                LOGGER.warn(errorMessage);
                LOGGER.warn("\nDetected banned imports will not fail the build as the 'failBuild' flag is set to false!");
            } else {
                LOGGER.debug("No banned imports found");
            }
        }
        catch (RuntimeIOException e) {
            throw new EnforcerRuleException(e.getMessage(), (Exception)e);
        }
        catch (BannedImportDefinitionException e) {
            throw new EnforcerRuleException("RestrictImports rule configuration error: " + e.getMessage(), (Exception)e);
        }
        catch (EnforcerRuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EnforcerRuleException("Encountered unexpected exception: " + e.getLocalizedMessage(), e);
        }
    }

    private BannedImportGroups assembleGroups() {
        if (!this.groups.isEmpty()) {
            List<BannedImportGroup> bannedImportGroups = this.groups.stream().map(BannedImportGroupDefinition::createGroupFromPluginConfiguration).collect(Collectors.toList());
            return BannedImportGroups.builder().withGroups(bannedImportGroups).build();
        }
        BannedImportGroup singleGroup = this.createGroupFromPluginConfiguration();
        return BannedImportGroups.builder().withGroup(singleGroup).build();
    }

    private AnalyzerSettings createAnalyzerSettingsFromPluginConfiguration(MavenProject mavenProject) {
        Collection<Path> srcDirectories = this.listSourceRoots(mavenProject.getCompileSourceRoots());
        List<Path> testDirectories = this.includeTestCode ? this.listSourceRoots(mavenProject.getTestCompileSourceRoots()) : Collections.emptyList();
        Charset sourceFileCharset = this.determineSourceFileCharset(mavenProject);
        return AnalyzerSettings.builder().withSrcDirectories(srcDirectories).withTestDirectories(testDirectories).withSourceFileCharset(sourceFileCharset).build();
    }

    private Charset determineSourceFileCharset(MavenProject mavenProject) {
        String mavenCharsetName = (String)mavenProject.getProperties().get("project.build.sourceEncoding");
        if (mavenCharsetName != null) {
            return Charset.forName(mavenCharsetName);
        }
        return Charset.defaultCharset();
    }

    private Collection<Path> listSourceRoots(Collection pathNames) {
        Collection pathNamesAsString = pathNames;
        return pathNamesAsString.stream().peek(pathName -> LOGGER.debug("Including source dir: {}", pathName)).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
    }

    private void checkGroups(boolean condition) {
        if (!condition) {
            throw new IllegalArgumentException("Configuration error: you can either define a list of banned import definitions using <groups> OR define a single banned import definition on top level without <groups> but not both");
        }
    }

    @Override
    public void setBasePackage(String basePackage) {
        this.checkGroups(this.groups.isEmpty());
        super.setBasePackage(basePackage);
    }

    @Override
    public void setBasePackages(List<String> basePackages) {
        this.checkGroups(this.groups.isEmpty());
        super.setBasePackages(basePackages);
    }

    @Override
    public void setBannedImport(String bannedImport) {
        this.checkGroups(this.groups.isEmpty());
        super.setBannedImport(bannedImport);
    }

    @Override
    public void setBannedImports(List<String> bannedPackages) {
        this.checkGroups(this.groups.isEmpty());
        super.setBannedImports(bannedPackages);
    }

    @Override
    public void setAllowedImport(String allowedImport) {
        this.checkGroups(this.groups.isEmpty());
        super.setAllowedImport(allowedImport);
    }

    @Override
    public void setAllowedImports(List<String> allowedImports) {
        this.checkGroups(this.groups.isEmpty());
        super.setAllowedImports(allowedImports);
    }

    @Override
    public void setExclusion(String exclusion) {
        this.checkGroups(this.groups.isEmpty());
        super.setExclusion(exclusion);
    }

    @Override
    public void setExclusions(List<String> exclusions) {
        this.checkGroups(this.groups.isEmpty());
        super.setExclusions(exclusions);
    }

    @Override
    public void setReason(String reason) {
        this.checkGroups(this.groups.isEmpty());
        super.setReason(reason);
    }

    public void setGroups(List<BannedImportGroupDefinition> groups) {
        this.checkGroups(!this.hasInput());
        Preconditions.checkArgument((groups != null && !groups.isEmpty() ? 1 : 0) != 0, (Object)"Groups may not be empty");
        this.groups = groups;
    }

    public final void setIncludeTestCode(boolean includeTestCode) {
        this.includeTestCode = includeTestCode;
    }

    @Deprecated
    public final void setCommentLineBufferSize(int commentLineBufferSize) {
        throw new RuntimeException("restrict-imports-enforcer rule: Deprecation warning (since 0.16.0):\nSetting commentLineBufferSize is no longer necessary, as we now use a dynamic buffer. This property no longer has any effect and will be removed in later versions!");
    }

    public void setFailBuild(boolean failBuild) {
        this.failBuild = failBuild;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public String getCacheId() {
        return "";
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule rule) {
        return false;
    }
}

