/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports.parser.lang;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.skuzzle.enforcer.restrictimports.parser.ImportStatement;
import de.skuzzle.enforcer.restrictimports.parser.lang.LanguageSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class JavaLanguageSupport
implements LanguageSupport {
    private static final String IMPORT_STATEMENT = "import ";
    private static final String PACKAGE_STATEMENT = "package ";

    @Override
    public Set<String> getSupportedFileExtensions() {
        return ImmutableSet.of((Object)"java");
    }

    @Override
    public Optional<String> parsePackage(String line) {
        if (!this.isPackage(line)) {
            return Optional.empty();
        }
        return Optional.of(JavaLanguageSupport.extractPackageName(line));
    }

    @Override
    public List<ImportStatement> parseImport(String line, int lineNumber) {
        if (!this.isImport(line)) {
            return ImmutableList.of();
        }
        String trimmed = line.trim();
        int start = 0;
        int semiIdx = trimmed.indexOf(59);
        ArrayList<ImportStatement> imports = new ArrayList<ImportStatement>();
        while (semiIdx > 0) {
            String importStatement = trimmed.substring(start, semiIdx);
            String packageOnly = importStatement.trim().substring(IMPORT_STATEMENT.length()).trim();
            imports.add(new ImportStatement(packageOnly, lineNumber));
            start = semiIdx + 1;
            semiIdx = trimmed.indexOf(59, start);
        }
        return imports;
    }

    private boolean is(String compare, String line) {
        return line.startsWith(compare) && line.endsWith(";");
    }

    private boolean isPackage(String line) {
        return this.is(PACKAGE_STATEMENT, line);
    }

    private boolean isImport(String line) {
        return this.is(IMPORT_STATEMENT, line);
    }

    private static String extractPackageName(String line) {
        int spaceIdx = line.indexOf(" ");
        int semiIdx = line.indexOf(";");
        String sub = line.substring(spaceIdx, semiIdx);
        return sub.trim();
    }
}

