/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports.parser;

import de.skuzzle.enforcer.restrictimports.io.RuntimeIOException;
import de.skuzzle.enforcer.restrictimports.parser.LineSupplier;
import de.skuzzle.enforcer.restrictimports.parser.TransientCommentReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.stream.Stream;

class SkipCommentsLineSupplier
implements LineSupplier {
    private final Charset charset;

    public SkipCommentsLineSupplier(Charset charset) {
        this.charset = charset;
    }

    @Override
    public Stream<String> lines(Path path) throws IOException {
        BufferedReader fromFile = Files.newBufferedReader(path, this.charset);
        TransientCommentReader skipComments = new TransientCommentReader(fromFile, true);
        BufferedReader lineReader = new BufferedReader(skipComments);
        return (Stream)((Stream)((Stream)lineReader.lines().onClose(() -> this.close(lineReader))).onClose(() -> this.close(skipComments))).onClose(() -> this.close(fromFile));
    }

    private void close(Reader reader) {
        try {
            reader.close();
        }
        catch (IOException e) {
            throw new RuntimeIOException("Error while closing reader", e);
        }
    }
}

