/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports.parser;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

public final class ImportStatement {
    private static final String STATIC_IMPORT_PREFIX = "static ";
    private final String importName;
    private final int line;
    private final boolean staticImport;

    public ImportStatement(String importName, int line) {
        Preconditions.checkArgument((importName != null && !importName.isEmpty() ? 1 : 0) != 0, (Object)"importName must not be empty");
        Preconditions.checkArgument((!importName.startsWith("import ") ? 1 : 0) != 0, (String)"importName should be the raw package name without 'import ' prefix but was: '%s'", (Object)importName);
        Preconditions.checkArgument((boolean)importName.trim().equals(importName), (String)"importName has leading or trailing spaces: '%s'", (Object)importName);
        Preconditions.checkArgument((line > 0 ? 1 : 0) != 0, (Object)"line numbers should be 1-based and not start at 0");
        this.importName = importName;
        this.line = line;
        this.staticImport = importName.startsWith(STATIC_IMPORT_PREFIX);
    }

    public int getLine() {
        return this.line;
    }

    public String getImportName() {
        return this.importName;
    }

    public String getFqcn() {
        if (this.staticImport) {
            return this.importName.substring(STATIC_IMPORT_PREFIX.length());
        }
        return this.importName;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("import", (Object)this.importName).add("line", this.line).add("static", this.staticImport).toString();
    }

    public int hashCode() {
        return Objects.hash(this.importName, this.line, this.staticImport);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof ImportStatement && Objects.equals(this.line, ((ImportStatement)obj).line) && Objects.equals(this.staticImport, ((ImportStatement)obj).staticImport) && Objects.equals(this.importName, ((ImportStatement)obj).importName);
    }
}

