/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports.analyze;

import de.skuzzle.enforcer.restrictimports.analyze.BannedImportGroup;
import de.skuzzle.enforcer.restrictimports.analyze.BannedImportGroups;
import de.skuzzle.enforcer.restrictimports.analyze.MatchedFile;
import de.skuzzle.enforcer.restrictimports.analyze.MatchedImport;
import de.skuzzle.enforcer.restrictimports.analyze.PackagePattern;
import de.skuzzle.enforcer.restrictimports.parser.ImportStatement;
import de.skuzzle.enforcer.restrictimports.parser.ParsedFile;
import java.util.ArrayList;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ImportAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportAnalyzer.class);

    ImportAnalyzer() {
    }

    public Optional<MatchedFile> matchFile(ParsedFile sourceFile, BannedImportGroups groups) {
        LOGGER.trace("Analyzing {} for banned imports", (Object)sourceFile);
        BannedImportGroup group = groups.selectGroupFor(sourceFile.getFqcn()).orElse(null);
        if (group == null) {
            return Optional.empty();
        }
        ArrayList<MatchedImport> matches = new ArrayList<MatchedImport>();
        for (ImportStatement importStmt : sourceFile.getImports()) {
            group.ifImportIsBanned(importStmt.getImportName()).map(bannedImport -> new MatchedImport(importStmt.getLine(), importStmt.getImportName(), (PackagePattern)bannedImport)).ifPresent(matches::add);
        }
        if (matches.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new MatchedFile(sourceFile.getPath(), matches, group));
    }
}

