/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports.rule;

import com.google.common.base.Preconditions;
import de.skuzzle.enforcer.restrictimports.analyze.AnalyzeResult;
import de.skuzzle.enforcer.restrictimports.analyze.AnalyzerSettings;
import de.skuzzle.enforcer.restrictimports.analyze.BannedImportDefinitionException;
import de.skuzzle.enforcer.restrictimports.analyze.BannedImportGroup;
import de.skuzzle.enforcer.restrictimports.analyze.BannedImportGroups;
import de.skuzzle.enforcer.restrictimports.analyze.CommentBufferOverflowException;
import de.skuzzle.enforcer.restrictimports.analyze.RuntimeIOException;
import de.skuzzle.enforcer.restrictimports.analyze.SourceTreeAnalyzer;
import de.skuzzle.enforcer.restrictimports.formatting.MatchFormatter;
import de.skuzzle.enforcer.restrictimports.rule.BannedImportGroupDefinition;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestrictImports
extends BannedImportGroupDefinition
implements EnforcerRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestrictImports.class);
    private List<BannedImportGroupDefinition> groups = new ArrayList<BannedImportGroupDefinition>();
    private boolean includeTestCode;
    private int commentLineBufferSize = 128;
    private Charset sourceFileCharset;

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        try {
            MavenProject project = (MavenProject)helper.evaluate("${project}");
            LOGGER.debug("Checking for banned imports");
            BannedImportGroups groups = this.assembleGroups();
            LOGGER.debug("Banned import groups:\n{}", (Object)groups);
            AnalyzerSettings analyzerSettings = this.createAnalyzerSettingsFromPluginConfiguration(project);
            LOGGER.debug("Analyzer settings:\n{}", (Object)analyzerSettings);
            AnalyzeResult analyzeResult = SourceTreeAnalyzer.getInstance().analyze(analyzerSettings, groups);
            LOGGER.debug("Analyzer result:\n{}", (Object)analyzeResult);
            if (analyzeResult.bannedImportsFound()) {
                String errorMessage = MatchFormatter.getInstance().formatMatches(analyzerSettings.getRootDirectories(), analyzeResult);
                throw new EnforcerRuleException(errorMessage);
            }
            LOGGER.debug("No banned imports found");
        }
        catch (RuntimeIOException e) {
            throw new EnforcerRuleException(e.getMessage(), (Exception)e);
        }
        catch (CommentBufferOverflowException e) {
            throw new EnforcerRuleException(String.format("Error while reading java source file. The comment line buffer is too small. Please set <commentLineBufferSize> to a value greater than %d. %s", this.commentLineBufferSize, e.getMessage()));
        }
        catch (BannedImportDefinitionException e) {
            throw new EnforcerRuleException("RestrictImports rule configuration error: " + e.getMessage(), (Exception)e);
        }
        catch (EnforcerRuleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EnforcerRuleException("Encountered unexpected exception: " + e.getLocalizedMessage(), e);
        }
    }

    private BannedImportGroups assembleGroups() {
        if (!this.groups.isEmpty()) {
            List<BannedImportGroup> bannedImportGroups = this.groups.stream().map(BannedImportGroupDefinition::createGroupFromPluginConfiguration).collect(Collectors.toList());
            return BannedImportGroups.builder().withGroups(bannedImportGroups).build();
        }
        BannedImportGroup singleGroup = this.createGroupFromPluginConfiguration();
        return BannedImportGroups.builder().withGroup(singleGroup).build();
    }

    private AnalyzerSettings createAnalyzerSettingsFromPluginConfiguration(MavenProject mavenProject) {
        Collection sourceRoots = this.listSourceRoots(mavenProject).collect(Collectors.toList());
        Charset sourceFileCharset = this.determineSourceFileCharset(mavenProject);
        return AnalyzerSettings.builder().withRootDirectories(sourceRoots).withCommentLineBufferSize(this.commentLineBufferSize).withSourceFileCharset(sourceFileCharset).build();
    }

    private Charset determineSourceFileCharset(MavenProject mavenProject) {
        if (this.sourceFileCharset != null) {
            return this.sourceFileCharset;
        }
        String mavenCharsetName = (String)mavenProject.getProperties().get("project.build.sourceEncoding");
        if (mavenCharsetName != null) {
            return Charset.forName(mavenCharsetName);
        }
        return Charset.defaultCharset();
    }

    private Stream<Path> listSourceRoots(MavenProject project) {
        Stream rootFolders;
        Stream compileStream = project.getCompileSourceRoots().stream();
        if (this.includeTestCode) {
            Stream testStream = project.getTestCompileSourceRoots().stream();
            rootFolders = Stream.concat(compileStream, testStream);
        } else {
            rootFolders = compileStream;
        }
        return rootFolders.peek(root -> LOGGER.debug("Including source dir: {}", root)).map(x$0 -> Paths.get(x$0, new String[0]));
    }

    private void checkGroups(boolean condition) {
        if (!condition) {
            throw new IllegalArgumentException("You can either define a list of banned import definitions using <groups> OR define a single banned import definition on top level without <groups> but not both");
        }
    }

    @Override
    public void setBasePackage(String basePackage) {
        this.checkGroups(this.groups.isEmpty());
        super.setBasePackage(basePackage);
    }

    @Override
    public void setBasePackages(List<String> basePackages) {
        this.checkGroups(this.groups.isEmpty());
        super.setBasePackages(basePackages);
    }

    @Override
    public void setBannedImport(String bannedImport) {
        this.checkGroups(this.groups.isEmpty());
        super.setBannedImport(bannedImport);
    }

    @Override
    public void setBannedImports(List<String> bannedPackages) {
        this.checkGroups(this.groups.isEmpty());
        super.setBannedImports(bannedPackages);
    }

    @Override
    public void setAllowedImport(String allowedImport) {
        this.checkGroups(this.groups.isEmpty());
        super.setAllowedImport(allowedImport);
    }

    @Override
    public void setAllowedImports(List<String> allowedImports) {
        this.checkGroups(this.groups.isEmpty());
        super.setAllowedImports(allowedImports);
    }

    @Override
    public void setExclusion(String exclusion) {
        this.checkGroups(this.groups.isEmpty());
        super.setExclusion(exclusion);
    }

    @Override
    public void setExclusions(List<String> exclusions) {
        this.checkGroups(this.groups.isEmpty());
        super.setExclusions(exclusions);
    }

    @Override
    public void setReason(String reason) {
        this.checkGroups(this.groups.isEmpty());
        super.setReason(reason);
    }

    public void setGroups(List<BannedImportGroupDefinition> groups) {
        this.checkGroups(!this.hasInput());
        Preconditions.checkArgument((groups != null && !groups.isEmpty() ? 1 : 0) != 0, (Object)"Groups may not be empty");
        this.groups = groups;
    }

    public final void setIncludeTestCode(boolean includeTestCode) {
        this.includeTestCode = includeTestCode;
    }

    public final void setCommentLineBufferSize(int commentLineBufferSize) {
        Preconditions.checkArgument((commentLineBufferSize > 0 ? 1 : 0) != 0, (Object)"Configuration error: commentLineBufferSize must be > 0");
        this.commentLineBufferSize = commentLineBufferSize;
    }

    public final void setSourceFileCharset(String sourceFileCharset) {
        this.sourceFileCharset = Charset.forName(sourceFileCharset);
    }

    public String getCacheId() {
        return "";
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule rule) {
        return false;
    }
}

