/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports.formatting;

import de.skuzzle.enforcer.restrictimports.analyze.AnalyzeResult;
import de.skuzzle.enforcer.restrictimports.analyze.BannedImportGroup;
import de.skuzzle.enforcer.restrictimports.analyze.MatchedFile;
import de.skuzzle.enforcer.restrictimports.analyze.MatchedImport;
import de.skuzzle.enforcer.restrictimports.formatting.MatchFormatter;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

class MatchFormatterImpl
implements MatchFormatter {
    static final MatchFormatter INSTANCE = new MatchFormatterImpl();

    MatchFormatterImpl() {
    }

    @Override
    public String formatMatches(Collection<Path> roots, AnalyzeResult analyzeResult) {
        StringBuilder b = new StringBuilder("\nBanned imports detected:\n");
        Map<BannedImportGroup, List<MatchedFile>> matchesByGroup = analyzeResult.getFileMatches().stream().collect(Collectors.groupingBy(MatchedFile::getMatchedBy));
        matchesByGroup.forEach((group, matches) -> {
            String message = group.getReason();
            if (message != null && !message.isEmpty()) {
                b.append("Reason: ").append(message).append("\n");
            }
            analyzeResult.getFileMatches().forEach(fileMatch -> {
                b.append("\tin file: ").append(MatchFormatterImpl.relativize(roots, fileMatch.getSourceFile())).append("\n");
                fileMatch.getMatchedImports().forEach(match -> this.appendMatch((MatchedImport)match, b));
            });
        });
        return b.toString();
    }

    private static Path relativize(Collection<Path> roots, Path path) {
        return roots.stream().filter(path::startsWith).map(root -> root.relativize(path)).findFirst().orElse(path);
    }

    private void appendMatch(MatchedImport match, StringBuilder b) {
        b.append("\t\t").append(match.getMatchedString()).append(" (Line: ").append(match.getImportLine()).append(", Matched by: ").append(match.getMatchedBy()).append(")\n");
    }
}

