/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports.analyze;

import de.skuzzle.enforcer.restrictimports.analyze.BannedImportGroup;
import de.skuzzle.enforcer.restrictimports.analyze.BannedImportGroups;
import de.skuzzle.enforcer.restrictimports.analyze.ImportMatcher;
import de.skuzzle.enforcer.restrictimports.analyze.LineSupplier;
import de.skuzzle.enforcer.restrictimports.analyze.MatchedFile;
import de.skuzzle.enforcer.restrictimports.analyze.MatchedImport;
import de.skuzzle.enforcer.restrictimports.analyze.PackagePattern;
import de.skuzzle.enforcer.restrictimports.analyze.RuntimeIOException;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Stream;

class ImportMatcherImpl
implements ImportMatcher {
    private final LineSupplier supplier;

    ImportMatcherImpl(LineSupplier supplier) {
        this.supplier = supplier;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<MatchedFile> matchFile(Path sourceFile, BannedImportGroups groups) {
        ArrayList<MatchedImport> matches = new ArrayList<MatchedImport>();
        try (Stream<String> lines = this.supplier.lines(sourceFile);){
            Optional<MatchedFile> optional;
            Iterable lineIt = lines.map(String::trim)::iterator;
            int row = 1;
            String javaFileName = this.getJavaFileName(sourceFile);
            BannedImportGroup group = groups.selectGroupFor(javaFileName).orElse(null);
            for (String line : lineIt) {
                if (!line.isEmpty()) {
                    Object packageName;
                    if (this.isPackage(line)) {
                        packageName = ImportMatcherImpl.extractPackageName(line);
                        String fqcn = this.guessFQCN((String)packageName, javaFileName);
                        Optional<BannedImportGroup> groupMatch = groups.selectGroupFor(fqcn);
                        if (!groupMatch.isPresent()) {
                            Optional<MatchedFile> optional2 = Optional.empty();
                            return optional2;
                        }
                        group = groupMatch.get();
                    } else {
                        if (!this.isImport(line)) {
                            if (matches.isEmpty()) {
                                packageName = Optional.empty();
                                return packageName;
                            }
                            packageName = Optional.of(new MatchedFile(sourceFile, matches, group));
                            return packageName;
                        }
                        String importName = ImportMatcherImpl.extractPackageName(line);
                        int lineNumber = row;
                        group.ifImportIsBanned(importName).map(bannedImport -> new MatchedImport(lineNumber, importName, (PackagePattern)bannedImport)).ifPresent(matches::add);
                    }
                }
                ++row;
            }
            if (matches.isEmpty()) {
                optional = Optional.empty();
                return optional;
            }
            optional = Optional.of(new MatchedFile(sourceFile, matches, group));
            return optional;
        }
        catch (RuntimeIOException e) {
            throw e;
        }
        catch (IOException e) {
            throw new RuntimeIOException(String.format("Encountered IOException while analyzing %s for banned imports", sourceFile), e);
        }
    }

    private String guessFQCN(String packageName, String javaFileName) {
        return packageName.isEmpty() ? javaFileName : packageName + "." + javaFileName;
    }

    private String getJavaFileName(Path file) {
        String s = file.getFileName().toString();
        int i = s.lastIndexOf(".java");
        return s.substring(0, i);
    }

    private static String extractPackageName(String line) {
        int spaceIdx = line.indexOf(" ");
        int semiIdx = line.indexOf(";");
        String sub = line.substring(spaceIdx, semiIdx);
        return sub.trim();
    }

    private boolean is(String compare, String line) {
        return line.startsWith(compare) && line.endsWith(";");
    }

    private boolean isPackage(String line) {
        return this.is("package ", line);
    }

    private boolean isImport(String line) {
        return this.is("import ", line);
    }
}

