/*
 * Decompiled with CFR 0.152.
 */
package de.skuzzle.enforcer.restrictimports;

import com.google.common.base.Preconditions;
import de.skuzzle.enforcer.restrictimports.api.AnalyzerFactory;
import de.skuzzle.enforcer.restrictimports.api.SourceTreeAnalyzer;
import de.skuzzle.enforcer.restrictimports.model.BannedImportGroup;
import de.skuzzle.enforcer.restrictimports.model.Match;
import de.skuzzle.enforcer.restrictimports.model.PackagePattern;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class RestrictImports
implements EnforcerRule {
    private static final PackagePattern DEFAULT_BASE_PACKAGE = PackagePattern.parse("**");
    private PackagePattern basePackage = DEFAULT_BASE_PACKAGE;
    private List<PackagePattern> basePackages = new ArrayList<PackagePattern>();
    private PackagePattern bannedImport = null;
    private List<PackagePattern> bannedImports = new ArrayList<PackagePattern>();
    private PackagePattern allowedImport = null;
    private List<PackagePattern> allowedImports = new ArrayList<PackagePattern>();
    private PackagePattern exclusion = null;
    private List<PackagePattern> exclusions = new ArrayList<PackagePattern>();
    private boolean includeTestCode;
    private String reason;
    private static final SourceTreeAnalyzer ANALYZER = AnalyzerFactory.getInstance().createAnalyzer();

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        Log log = helper.getLog();
        try {
            MavenProject project = (MavenProject)helper.evaluate("${project}");
            log.debug((CharSequence)"Checking for banned imports");
            BannedImportGroup group = new BannedImportGroup(this.assembleList(this.basePackage, this.basePackages), this.assembleList(this.bannedImport, this.bannedImports), this.assembleList(this.allowedImport, this.allowedImports), this.assembleList(this.exclusion, this.exclusions), this.reason);
            this.checkConsistency(group);
            Collection sourceRoots = this.listSourceRoots(project, log).collect(Collectors.toList());
            Map<String, List<Match>> matches = ANALYZER.analyze(sourceRoots.stream(), group);
            if (!matches.isEmpty()) {
                throw new EnforcerRuleException(this.formatErrorString(sourceRoots, group, matches));
            }
            log.debug((CharSequence)"No banned imports found");
        }
        catch (Exception e) {
            throw new EnforcerRuleException("Encountered unexpected exception: " + e.getLocalizedMessage(), e);
        }
    }

    private void checkConsistency(BannedImportGroup group) throws EnforcerRuleException {
        ANALYZER.checkGroupConsistency(group);
    }

    private List<PackagePattern> assembleList(PackagePattern single, List<PackagePattern> multi) {
        if (single == null) {
            return multi;
        }
        return Collections.singletonList(single);
    }

    private static String relativize(Collection<Path> roots, String path) {
        for (Path root : roots) {
            String absoluteRoot = root.toAbsolutePath().toString();
            if (!path.startsWith(absoluteRoot)) continue;
            return path.substring(absoluteRoot.length());
        }
        return path;
    }

    private String formatErrorString(Collection<Path> roots, BannedImportGroup group, Map<String, List<Match>> groups) {
        StringBuilder b = new StringBuilder("\nBanned imports detected:\n");
        String message = group.getReason();
        if (message != null && !message.isEmpty()) {
            b.append("Reason: ").append(message).append("\n");
        }
        groups.forEach((fileName, matches) -> {
            b.append("\tin file: ").append(RestrictImports.relativize(roots, fileName)).append("\n");
            matches.forEach(match -> this.appendMatch((Match)match, b));
        });
        return b.toString();
    }

    private void appendMatch(Match match, StringBuilder b) {
        b.append("\t\t").append(match.getMatchedString()).append(" (Line: ").append(match.getImportLine()).append(")\n");
    }

    private Stream<Path> listSourceRoots(MavenProject project, Log log) {
        Stream rootFolders;
        Stream compileStream = project.getCompileSourceRoots().stream();
        if (this.includeTestCode) {
            Stream testStream = project.getTestCompileSourceRoots().stream();
            rootFolders = Stream.concat(compileStream, testStream);
        } else {
            rootFolders = compileStream;
        }
        return rootFolders.peek(root -> log.debug((CharSequence)("Including source dir: " + root))).map(x$0 -> Paths.get(x$0, new String[0]));
    }

    public String getCacheId() {
        return "";
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule rule) {
        return false;
    }

    public final void setBasePackage(String basePackage) {
        Preconditions.checkArgument((boolean)this.basePackages.isEmpty(), (Object)"Configuration error: you should either specify a single base package using <basePackage> or multiple base packages using <basePackages> but not both");
        this.basePackage = PackagePattern.parse(basePackage);
    }

    public final void setBasePackages(List<String> basePackages) {
        Preconditions.checkArgument((this.basePackage == DEFAULT_BASE_PACKAGE ? 1 : 0) != 0, (Object)"Configuration error: you should either specify a single base package using <basePackage> or multiple base packages using <basePackages> but not both");
        Preconditions.checkArgument((basePackages != null && !basePackages.isEmpty() ? 1 : 0) != 0, (Object)"bannedPackages must not be empty");
        this.basePackage = null;
        this.basePackages = PackagePattern.parseAll(basePackages);
    }

    public void setBannedImport(String bannedImport) {
        Preconditions.checkArgument((boolean)this.bannedImports.isEmpty(), (Object)"Configuration error: you should either specify a single banned import using <bannedImport> or multiple banned imports using <bannedImports> but not both");
        this.bannedImport = PackagePattern.parse(bannedImport);
    }

    public final void setBannedImports(List<String> bannedPackages) {
        Preconditions.checkArgument((this.bannedImport == null ? 1 : 0) != 0, (Object)"Configuration error: you should either specify a single banned import using <bannedImport> or multiple banned imports using <bannedImports> but not both");
        Preconditions.checkArgument((bannedPackages != null && !bannedPackages.isEmpty() ? 1 : 0) != 0, (Object)"bannedPackages must not be empty");
        this.bannedImport = null;
        this.bannedImports = PackagePattern.parseAll(bannedPackages);
    }

    public final void setAllowedImport(String allowedImport) {
        Preconditions.checkArgument((boolean)this.allowedImports.isEmpty(), (Object)"Configuration error: you should either specify a single allowed import using <allowedImport> or multiple allowed imports using <allowedImports> but not both");
        this.allowedImport = PackagePattern.parse(allowedImport);
    }

    public final void setAllowedImports(List<String> allowedImports) {
        Preconditions.checkArgument((this.allowedImport == null ? 1 : 0) != 0, (Object)"Configuration error: you should either specify a single allowed import using <allowedImport> or multiple allowed imports using <allowedImports> but not both");
        this.allowedImports = PackagePattern.parseAll(allowedImports);
    }

    public final void setExclusion(String exclusion) {
        Preconditions.checkArgument((boolean)this.exclusions.isEmpty(), (Object)"Configuration error: you should either specify a single exclusion using <exclusion> or multiple exclusions using <exclusions> but not both");
        this.exclusion = PackagePattern.parse(exclusion);
    }

    public final void setExclusions(List<String> exclusions) {
        Preconditions.checkArgument((this.exclusion == null ? 1 : 0) != 0, (Object)"Configuration error: you should either specify a single exclusion using <exclusion> or multiple exclusions using <exclusions> but not both");
        this.exclusions = PackagePattern.parseAll(exclusions);
    }

    public final void setIncludeTestCode(boolean includeTestCode) {
        this.includeTestCode = includeTestCode;
    }

    public final void setReason(String reason) {
        this.reason = reason;
    }
}

