/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.fastcsv.reader;

import de.siegmar.fastcsv.reader.CommentStrategy;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

public record CsvIndex(int bomHeaderLength, long fileSize, byte fieldSeparator, byte quoteCharacter, CommentStrategy commentStrategy, byte commentCharacter, long recordCount, List<CsvPage> pages) implements Serializable
{
    public CsvIndex(int bomHeaderLength, long fileSize, byte fieldSeparator, byte quoteCharacter, CommentStrategy commentStrategy, byte commentCharacter, long recordCount, List<CsvPage> pages) {
        this.bomHeaderLength = bomHeaderLength;
        this.fileSize = fileSize;
        this.fieldSeparator = fieldSeparator;
        this.quoteCharacter = quoteCharacter;
        this.commentStrategy = Objects.requireNonNull(commentStrategy, "commentStrategy must not be null");
        this.commentCharacter = commentCharacter;
        this.recordCount = recordCount;
        this.pages = List.copyOf((Collection)Objects.requireNonNull(pages, "pages must not be null"));
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", CsvIndex.class.getSimpleName() + "[", "]").add("bomHeaderLength=" + this.bomHeaderLength).add("fileSize=" + this.fileSize).add("fieldSeparator=" + this.fieldSeparator).add("quoteCharacter=" + this.quoteCharacter).add("commentStrategy=" + String.valueOf((Object)this.commentStrategy)).add("commentCharacter=" + this.commentCharacter).add("recordCount=" + this.recordCount).add("pageCount=" + this.pages.size()).toString();
    }

    public record CsvPage(long offset, long startingLineNumber) implements Serializable
    {
    }
}

