/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.fastcsv.reader;

import de.siegmar.fastcsv.reader.BomInputStreamReader;
import de.siegmar.fastcsv.reader.CloseableIterator;
import de.siegmar.fastcsv.reader.CommentStrategy;
import de.siegmar.fastcsv.reader.CsvCallbackHandler;
import de.siegmar.fastcsv.reader.CsvParseException;
import de.siegmar.fastcsv.reader.CsvParser;
import de.siegmar.fastcsv.reader.CsvRecord;
import de.siegmar.fastcsv.reader.CsvRecordHandler;
import de.siegmar.fastcsv.reader.NamedCsvRecord;
import de.siegmar.fastcsv.reader.NamedCsvRecordHandler;
import de.siegmar.fastcsv.reader.RecordType;
import de.siegmar.fastcsv.reader.RelaxedCsvParser;
import de.siegmar.fastcsv.reader.StrictCsvParser;
import de.siegmar.fastcsv.util.Nullable;
import de.siegmar.fastcsv.util.Preconditions;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class CsvReader<T>
implements Iterable<T>,
Closeable {
    private final CsvParser csvParser;
    private final CsvCallbackHandler<T> callbackHandler;
    private final CommentStrategy commentStrategy;
    private final boolean skipEmptyLines;
    private final boolean allowExtraFields;
    private final boolean allowMissingFields;
    private final boolean fieldCountConsistencyCheck;
    private final CloseableIterator<T> csvRecordIterator = new CsvRecordIterator();
    private int firstRecordFieldCount = -1;

    CsvReader(CsvParser csvParser, CsvCallbackHandler<T> callbackHandler, CommentStrategy commentStrategy, boolean skipEmptyLines, boolean allowExtraFields, boolean allowMissingFields) {
        this.csvParser = csvParser;
        this.callbackHandler = callbackHandler;
        this.commentStrategy = commentStrategy;
        this.skipEmptyLines = skipEmptyLines;
        this.allowExtraFields = allowExtraFields;
        this.allowMissingFields = allowMissingFields;
        this.fieldCountConsistencyCheck = !allowExtraFields || !allowMissingFields;
    }

    public static CsvReaderBuilder builder() {
        return new CsvReaderBuilder();
    }

    public void skipLines(int lineCount) {
        int i;
        if (lineCount < 0) {
            throw new IllegalArgumentException("lineCount must be non-negative");
        }
        try {
            for (i = 0; i < lineCount; ++i) {
                this.csvParser.skipLine(0);
            }
        }
        catch (EOFException e) {
            throw new CsvParseException("Not enough lines to skip. Skipped only %d line(s).".formatted(i), e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public int skipLines(Predicate<String> predicate, int maxLines) {
        int i;
        Objects.requireNonNull(predicate, "predicate must not be null");
        if (maxLines < 0) {
            throw new IllegalArgumentException("maxLines must be non-negative");
        }
        if (maxLines == 0) {
            return 0;
        }
        try {
            for (i = 0; i < maxLines; ++i) {
                String line = this.csvParser.peekLine();
                if (predicate.test(line)) {
                    return i;
                }
                this.csvParser.skipLine(line.length());
            }
        }
        catch (EOFException e) {
            throw new CsvParseException("No matching line found. Skipped %d line(s) before reaching end of data.".formatted(i), e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        throw new CsvParseException("No matching line found within the maximum limit of %d lines.".formatted(maxLines));
    }

    @Override
    public CloseableIterator<T> iterator() {
        return this.csvRecordIterator;
    }

    @Override
    public Spliterator<T> spliterator() {
        return new CsvSpliterator();
    }

    public Stream<T> stream() {
        return (Stream)StreamSupport.stream(this.spliterator(), false).onClose(() -> {
            try {
                this.close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    @Nullable
    private T fetchRecord() throws IOException {
        while (this.csvParser.parse()) {
            T csvRecord = this.processRecord();
            if (csvRecord == null) continue;
            return csvRecord;
        }
        this.callbackHandler.terminate();
        return null;
    }

    @Nullable
    private T processRecord() {
        T csvRecord = this.callbackHandler.buildRecord();
        if (csvRecord == null) {
            return null;
        }
        return switch (this.callbackHandler.getRecordType()) {
            default -> throw new IncompatibleClassChangeError();
            case RecordType.DATA -> {
                if (this.fieldCountConsistencyCheck) {
                    this.checkFieldCountConsistency(this.callbackHandler.getFieldCount());
                }
                yield csvRecord;
            }
            case RecordType.COMMENT -> this.commentStrategy == CommentStrategy.SKIP ? null : csvRecord;
            case RecordType.EMPTY -> this.skipEmptyLines ? null : csvRecord;
        };
    }

    private void checkFieldCountConsistency(int fieldCount) {
        if (this.firstRecordFieldCount == -1) {
            this.firstRecordFieldCount = fieldCount;
            return;
        }
        if (fieldCount > this.firstRecordFieldCount && !this.allowExtraFields || fieldCount < this.firstRecordFieldCount && !this.allowMissingFields) {
            throw new CsvParseException("Record %d has %d fields, but first record had %d fields".formatted(this.csvParser.getStartingLineNumber(), fieldCount, this.firstRecordFieldCount));
        }
    }

    @Override
    public void close() throws IOException {
        this.csvParser.close();
    }

    public String toString() {
        return new StringJoiner(", ", CsvReader.class.getSimpleName() + "[", "]").add("commentStrategy=" + String.valueOf((Object)this.commentStrategy)).add("skipEmptyLines=" + this.skipEmptyLines).add("allowExtraFields=" + this.allowExtraFields).add("allowMissingFields=" + this.allowMissingFields).add("parser=" + this.csvParser.getClass().getSimpleName()).toString();
    }

    @Nullable
    private T fetch() {
        try {
            return this.fetchRecord();
        }
        catch (IOException e) {
            throw new UncheckedIOException(this.buildExceptionMessage(), e);
        }
        catch (Throwable t) {
            throw new CsvParseException(this.buildExceptionMessage(), t);
        }
    }

    private String buildExceptionMessage() {
        return this.csvParser.getStartingLineNumber() == 1L ? "Exception when reading first record" : "Exception when reading record that started in line %d".formatted(this.csvParser.getStartingLineNumber());
    }

    private final class CsvRecordIterator
    implements CloseableIterator<T> {
        @Nullable
        private T fetchedRecord;
        private boolean fetched;

        private CsvRecordIterator() {
        }

        @Override
        public boolean hasNext() {
            if (!this.fetched) {
                this.fetchedRecord = CsvReader.this.fetch();
                this.fetched = true;
            }
            return this.fetchedRecord != null;
        }

        @Override
        public T next() {
            if (!this.fetched) {
                this.fetchedRecord = CsvReader.this.fetch();
            }
            if (this.fetchedRecord == null) {
                throw new NoSuchElementException();
            }
            this.fetched = false;
            return this.fetchedRecord;
        }

        @Override
        public void close() throws IOException {
            CsvReader.this.close();
        }
    }

    public static final class CsvReaderBuilder {
        private static final int DEFAULT_MAX_BUFFER_SIZE = 0x1000000;
        private String fieldSeparator = ",";
        private char quoteCharacter = (char)34;
        private CommentStrategy commentStrategy = CommentStrategy.NONE;
        private char commentCharacter = (char)35;
        private boolean skipEmptyLines = true;
        private boolean allowExtraFields;
        private boolean allowMissingFields;
        private boolean allowExtraCharsAfterClosingQuote;
        private boolean trimWhitespacesAroundQuotes;
        private boolean detectBomHeader;
        private int maxBufferSize = 0x1000000;

        private CsvReaderBuilder() {
        }

        public CsvReaderBuilder fieldSeparator(char fieldSeparator) {
            this.fieldSeparator = String.valueOf(fieldSeparator);
            return this;
        }

        public CsvReaderBuilder fieldSeparator(String fieldSeparator) {
            if (fieldSeparator == null || fieldSeparator.isEmpty()) {
                throw new IllegalArgumentException("fieldSeparator must not be null or empty");
            }
            this.fieldSeparator = fieldSeparator;
            return this;
        }

        public CsvReaderBuilder quoteCharacter(char quoteCharacter) {
            this.quoteCharacter = quoteCharacter;
            return this;
        }

        public CsvReaderBuilder commentStrategy(CommentStrategy commentStrategy) {
            this.commentStrategy = commentStrategy;
            return this;
        }

        public CsvReaderBuilder commentCharacter(char commentCharacter) {
            this.commentCharacter = commentCharacter;
            return this;
        }

        public CsvReaderBuilder skipEmptyLines(boolean skipEmptyLines) {
            this.skipEmptyLines = skipEmptyLines;
            return this;
        }

        public CsvReaderBuilder allowExtraFields(boolean allowExtraFields) {
            this.allowExtraFields = allowExtraFields;
            return this;
        }

        public CsvReaderBuilder allowMissingFields(boolean allowMissingFields) {
            this.allowMissingFields = allowMissingFields;
            return this;
        }

        public CsvReaderBuilder allowExtraCharsAfterClosingQuote(boolean allowExtraCharsAfterClosingQuote) {
            this.allowExtraCharsAfterClosingQuote = allowExtraCharsAfterClosingQuote;
            return this;
        }

        public CsvReaderBuilder trimWhitespacesAroundQuotes(boolean trimWhitespacesAroundQuotes) {
            this.trimWhitespacesAroundQuotes = trimWhitespacesAroundQuotes;
            return this;
        }

        public CsvReaderBuilder detectBomHeader(boolean detectBomHeader) {
            this.detectBomHeader = detectBomHeader;
            return this;
        }

        public CsvReaderBuilder maxBufferSize(int maxBufferSize) {
            Preconditions.checkArgument(maxBufferSize > 0, "maxBufferSize must be greater than 0");
            this.maxBufferSize = maxBufferSize;
            return this;
        }

        public CsvRecord ofSingleCsvRecord(String data) {
            return this.ofSingleCsvRecord(CsvRecordHandler.of(), data);
        }

        public <T> T ofSingleCsvRecord(CsvCallbackHandler<T> callbackHandler, String data) {
            T fetchedRecord = this.build(callbackHandler, data).fetch();
            if (fetchedRecord == null) {
                throw new CsvParseException("No record found in the provided data");
            }
            return fetchedRecord;
        }

        public CsvReader<CsvRecord> ofCsvRecord(InputStream inputStream) {
            return this.build(CsvRecordHandler.of(), inputStream);
        }

        public CsvReader<CsvRecord> ofCsvRecord(InputStream inputStream, Charset charset) {
            return this.build(CsvRecordHandler.of(), inputStream, charset);
        }

        public CsvReader<CsvRecord> ofCsvRecord(Reader reader) {
            return this.build(CsvRecordHandler.of(), reader);
        }

        public CsvReader<CsvRecord> ofCsvRecord(String data) {
            return this.build(CsvRecordHandler.of(), data);
        }

        public CsvReader<CsvRecord> ofCsvRecord(Path file) throws IOException {
            return this.build(CsvRecordHandler.of(), file);
        }

        public CsvReader<CsvRecord> ofCsvRecord(Path file, Charset charset) throws IOException {
            return this.build(CsvRecordHandler.of(), file, charset);
        }

        public CsvReader<NamedCsvRecord> ofNamedCsvRecord(InputStream inputStream) {
            return this.build(NamedCsvRecordHandler.of(), inputStream);
        }

        public CsvReader<NamedCsvRecord> ofNamedCsvRecord(InputStream inputStream, Charset charset) {
            return this.build(NamedCsvRecordHandler.of(), inputStream, charset);
        }

        public CsvReader<NamedCsvRecord> ofNamedCsvRecord(Reader reader) {
            return this.build(NamedCsvRecordHandler.of(), reader);
        }

        public CsvReader<NamedCsvRecord> ofNamedCsvRecord(String data) {
            return this.build(NamedCsvRecordHandler.of(), data);
        }

        public CsvReader<NamedCsvRecord> ofNamedCsvRecord(Path file) throws IOException {
            return this.build(NamedCsvRecordHandler.of(), file);
        }

        public CsvReader<NamedCsvRecord> ofNamedCsvRecord(Path file, Charset charset) throws IOException {
            return this.build(NamedCsvRecordHandler.of(), file, charset);
        }

        public <T> CsvReader<T> build(CsvCallbackHandler<T> callbackHandler, InputStream inputStream) {
            return this.build(callbackHandler, inputStream, StandardCharsets.UTF_8);
        }

        public <T> CsvReader<T> build(CsvCallbackHandler<T> callbackHandler, InputStream inputStream, Charset charset) {
            Objects.requireNonNull(callbackHandler, "callbackHandler must not be null");
            Objects.requireNonNull(inputStream, "inputStream must not be null");
            Objects.requireNonNull(charset, "charset must not be null");
            Reader reader = this.detectBomHeader ? new BomInputStreamReader(inputStream, charset) : new InputStreamReader(inputStream, charset);
            return this.build(callbackHandler, reader);
        }

        public <T> CsvReader<T> build(CsvCallbackHandler<T> callbackHandler, Reader reader) {
            Objects.requireNonNull(callbackHandler, "callbackHandler must not be null");
            Objects.requireNonNull(reader, "reader must not be null");
            CsvParser csvParser = this.isRelaxedConfiguration() ? new RelaxedCsvParser(this.fieldSeparator, this.quoteCharacter, this.commentStrategy, this.commentCharacter, this.trimWhitespacesAroundQuotes, callbackHandler, this.maxBufferSize, reader) : new StrictCsvParser(this.fieldSeparator.charAt(0), this.quoteCharacter, this.commentStrategy, this.commentCharacter, this.allowExtraCharsAfterClosingQuote, callbackHandler, this.maxBufferSize, reader);
            return this.newReader(callbackHandler, csvParser);
        }

        public <T> CsvReader<T> build(CsvCallbackHandler<T> callbackHandler, String data) {
            Objects.requireNonNull(callbackHandler, "callbackHandler must not be null");
            Objects.requireNonNull(data, "data must not be null");
            CsvParser csvParser = this.isRelaxedConfiguration() ? new RelaxedCsvParser(this.fieldSeparator, this.quoteCharacter, this.commentStrategy, this.commentCharacter, this.trimWhitespacesAroundQuotes, callbackHandler, this.maxBufferSize, data) : new StrictCsvParser(this.fieldSeparator.charAt(0), this.quoteCharacter, this.commentStrategy, this.commentCharacter, this.allowExtraCharsAfterClosingQuote, callbackHandler, data);
            return this.newReader(callbackHandler, csvParser);
        }

        public <T> CsvReader<T> build(CsvCallbackHandler<T> callbackHandler, Path file) throws IOException {
            return this.build(callbackHandler, file, StandardCharsets.UTF_8);
        }

        public <T> CsvReader<T> build(CsvCallbackHandler<T> callbackHandler, Path file, Charset charset) throws IOException {
            Objects.requireNonNull(callbackHandler, "callbackHandler must not be null");
            Objects.requireNonNull(file, "file must not be null");
            Objects.requireNonNull(charset, "charset must not be null");
            Reader reader = this.detectBomHeader ? new BomInputStreamReader(Files.newInputStream(file, new OpenOption[0]), charset) : new InputStreamReader(Files.newInputStream(file, new OpenOption[0]), charset);
            return this.build(callbackHandler, reader);
        }

        private boolean isRelaxedConfiguration() {
            boolean relaxed;
            boolean bl = relaxed = CsvReaderBuilder.isForceRelaxedParser() || this.fieldSeparator.length() > 1 || this.trimWhitespacesAroundQuotes;
            if (relaxed && this.allowExtraCharsAfterClosingQuote) {
                throw new IllegalStateException("allowExtraCharsAfterClosingQuote is not supported in relaxed mode");
            }
            return relaxed;
        }

        private static boolean isForceRelaxedParser() {
            return Boolean.parseBoolean(System.getProperty("de.siegmar.fastcsv.relaxed", "false"));
        }

        private <T> CsvReader<T> newReader(CsvCallbackHandler<T> callbackHandler, CsvParser csvParser) {
            return new CsvReader<T>(csvParser, callbackHandler, this.commentStrategy, this.skipEmptyLines, this.allowExtraFields, this.allowMissingFields);
        }

        public String toString() {
            return new StringJoiner(", ", CsvReaderBuilder.class.getSimpleName() + "[", "]").add("fieldSeparator=" + this.fieldSeparator).add("quoteCharacter=" + this.quoteCharacter).add("commentStrategy=" + String.valueOf((Object)this.commentStrategy)).add("commentCharacter=" + this.commentCharacter).add("skipEmptyLines=" + this.skipEmptyLines).add("allowExtraFields=" + this.allowExtraFields).add("allowMissingFields=" + this.allowMissingFields).add("allowExtraCharsAfterClosingQuote=" + this.allowExtraCharsAfterClosingQuote).add("trimWhitespacesAroundQuotes=" + this.trimWhitespacesAroundQuotes).add("detectBomHeader=" + this.detectBomHeader).add("maxBufferSize=" + this.maxBufferSize).toString();
        }
    }

    private final class CsvSpliterator
    implements Spliterator<T> {
        private CsvSpliterator() {
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            Object t = CsvReader.this.fetch();
            if (t != null) {
                action.accept(t);
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        public Spliterator<T> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 272;
        }
    }
}

