/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.fastcsv.reader;

import de.siegmar.fastcsv.reader.CsvCallbackHandler;
import de.siegmar.fastcsv.reader.CsvParseException;
import de.siegmar.fastcsv.reader.FieldModifier;
import de.siegmar.fastcsv.reader.FieldModifiers;
import de.siegmar.fastcsv.reader.RecordWrapper;
import java.util.Objects;

abstract class AbstractCsvCallbackHandler<T>
extends CsvCallbackHandler<T> {
    private static final int INITIAL_FIELDS_SIZE = 32;
    protected final FieldModifier fieldModifier;
    protected long startingLineNumber;
    protected String[] fields;
    protected int recordSize;
    protected int fieldIdx;
    protected boolean comment;

    protected AbstractCsvCallbackHandler() {
        this(FieldModifiers.NOP, 32);
    }

    protected AbstractCsvCallbackHandler(FieldModifier fieldModifier) {
        this(fieldModifier, 32);
    }

    AbstractCsvCallbackHandler(FieldModifier fieldModifier, int len) {
        this.fieldModifier = Objects.requireNonNull(fieldModifier, "fieldModifier must not be null");
        this.fields = new String[len];
    }

    @Override
    protected void beginRecord(long startingLineNumber) {
        this.startingLineNumber = startingLineNumber;
        this.fieldIdx = 0;
        this.recordSize = 0;
        this.comment = false;
    }

    @Override
    protected void addField(char[] buf, int offset, int len, boolean quoted) {
        if (this.recordSize + len > 0x4000000) {
            throw new CsvParseException(AbstractCsvCallbackHandler.maxRecordSizeExceededMessage(this.startingLineNumber));
        }
        this.addField(this.modifyField(this.materializeField(buf, offset, len), quoted), quoted);
    }

    protected void addField(String value, boolean quoted) {
        if (this.fieldIdx == this.fields.length) {
            this.extendCapacity();
        }
        this.fields[this.fieldIdx++] = value;
        this.recordSize += value.length();
    }

    protected String modifyField(String value, boolean quoted) {
        return this.fieldModifier.modify(this.startingLineNumber, this.fieldIdx, quoted, value);
    }

    protected String materializeField(char[] buf, int offset, int len) {
        return new String(buf, offset, len);
    }

    private static String maxRecordSizeExceededMessage(long line) {
        return String.format("Record starting at line %d has surpassed the maximum limit of %d characters", line, 0x4000000);
    }

    @Override
    protected void setComment(char[] buf, int offset, int len) {
        if (this.fieldIdx != 0) {
            throw new IllegalStateException("Comment must be the first and only field in a record");
        }
        if (this.recordSize + len > 0x4000000) {
            throw new CsvParseException(AbstractCsvCallbackHandler.maxRecordSizeExceededMessage(this.startingLineNumber));
        }
        this.setComment(this.modifyComment(this.materializeComment(buf, offset, len)));
    }

    protected void setComment(String value) {
        this.recordSize += value.length();
        this.comment = true;
        this.fields[this.fieldIdx++] = value;
    }

    protected String modifyComment(String field) {
        return this.fieldModifier.modifyComment(this.startingLineNumber, field);
    }

    protected String materializeComment(char[] buf, int offset, int len) {
        return new String(buf, offset, len);
    }

    private void extendCapacity() {
        int newLen = this.fields.length * 2;
        if (newLen > 16384) {
            throw new CsvParseException("Maximum number of fields exceeded: 16384");
        }
        String[] newFields = new String[newLen];
        System.arraycopy(this.fields, 0, newFields, 0, this.fieldIdx);
        this.fields = newFields;
    }

    protected String[] compactFields() {
        String[] ret = new String[this.fieldIdx];
        System.arraycopy(this.fields, 0, ret, 0, this.fieldIdx);
        return ret;
    }

    protected RecordWrapper<T> buildWrapper(T rec) {
        return new RecordWrapper<T>(this.comment, this.recordSize == 0, this.fieldIdx, rec);
    }
}

