/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.fastcsv.reader;

import de.siegmar.fastcsv.reader.CsvCallbackHandler;
import de.siegmar.fastcsv.reader.RecordWrapper;
import java.util.Objects;

public abstract class AbstractBaseCsvCallbackHandler<T>
extends CsvCallbackHandler<T> {
    private long startingLineNumber;
    private boolean comment;
    private boolean emptyLine;
    private int fieldCount;

    protected AbstractBaseCsvCallbackHandler() {
    }

    protected long getStartingLineNumber() {
        return this.startingLineNumber;
    }

    protected boolean isComment() {
        return this.comment;
    }

    protected boolean isEmptyLine() {
        return this.emptyLine;
    }

    protected int getFieldCount() {
        return this.fieldCount;
    }

    @Override
    protected final void beginRecord(long startingLineNumber) {
        this.startingLineNumber = startingLineNumber;
        this.fieldCount = 0;
        this.comment = false;
        this.emptyLine = true;
        this.handleBegin(startingLineNumber);
    }

    protected void handleBegin(long startingLineNumber) {
    }

    @Override
    protected final void addField(char[] buf, int offset, int len, boolean quoted) {
        this.emptyLine = this.emptyLine && len == 0;
        this.handleField(this.fieldCount++, buf, offset, len, quoted);
    }

    protected void handleField(int fieldIdx, char[] buf, int offset, int len, boolean quoted) {
    }

    @Override
    protected final void setComment(char[] buf, int offset, int len) {
        this.comment = true;
        this.emptyLine = false;
        this.handleComment(buf, offset, len);
        ++this.fieldCount;
    }

    protected void handleComment(char[] buf, int offset, int len) {
    }

    protected RecordWrapper<T> wrapRecord(T record) {
        return new RecordWrapper<T>(this.comment, this.emptyLine, this.fieldCount, Objects.requireNonNull(record, "record must not be null"));
    }
}

