/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;

final class ResourcePropertyUtils {
    private static final String COLON = ":";
    static final String MARKER = "__ILLEGAL_COLON_IN_TAG_NAME__";
    private static final Pattern PATTERN = Pattern.compile("<(/?)(\\s*)([\\w\\d]+):([\\w\\d]+):([\\w\\d]+)((?:\\s*[\\w\\d=\"]*\\s*)*)(/?)>");
    static final Charset UTF8 = Charset.forName("UTF-8");

    static InputStream escapedInputStream(InputStream inputStream) throws IOException {
        String rawData = IOUtils.toString((InputStream)inputStream, (Charset)UTF8);
        inputStream.close();
        Matcher matcher = PATTERN.matcher(rawData);
        String escapedData = matcher.replaceAll("<$1$2$3:$4__ILLEGAL_COLON_IN_TAG_NAME__$5$6$7>");
        return IOUtils.toInputStream((String)escapedData, (Charset)UTF8);
    }

    static String escapedKeyNameXml(String name) {
        return name.replace(COLON, MARKER);
    }

    static String filterMarker(String xml) {
        return xml.replaceAll(MARKER, COLON);
    }

    static String unescapedKeyNameXml(String name) {
        return name.replace(MARKER, COLON);
    }

    private ResourcePropertyUtils() {
    }
}

