/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Resource;

public final class QualifiedResource {
    private final Resource base;
    private final Resource resource;

    public QualifiedResource(Resource resource) {
        this(Resource.ROOT, resource);
    }

    public QualifiedResource(Resource base, Resource resource) {
        this.base = base;
        this.resource = resource;
    }

    public QualifiedResource append(QualifiedResource suffix) {
        return new QualifiedResource(this.base, this.resource.append(suffix.base).append(suffix.resource));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QualifiedResource)) {
            return false;
        }
        QualifiedResource other = (QualifiedResource)obj;
        if (this.base == null ? other.base != null : !this.base.equals(other.base)) {
            return false;
        }
        return !(this.resource == null ? other.resource != null : !this.resource.equals(other.resource));
    }

    public Resource getBase() {
        return this.base;
    }

    public QualifiedResource getParent() {
        return new QualifiedResource(this.base, this.resource.getParent());
    }

    public Resource getResource() {
        return this.resource;
    }

    public String getValue() {
        return this.base.append(this.resource).getValue();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.base == null ? 0 : this.base.hashCode());
        result = 31 * result + (this.resource == null ? 0 : this.resource.hashCode());
        return result;
    }

    public String toString() {
        return this.base.append(this.resource).toString();
    }
}

