/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Info;
import de.shadowhunt.subversion.LockToken;
import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.SubversionException;
import de.shadowhunt.subversion.internal.AbstractOperation;
import de.shadowhunt.subversion.internal.AbstractVoidOperation;
import de.shadowhunt.subversion.internal.QualifiedResource;
import java.io.Writer;
import java.net.URI;
import java.util.Optional;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

public class MergeOperation
extends AbstractVoidOperation {
    private final Resource base;
    private final Set<Info> infoSet;
    private final boolean releaseLocks;
    private final QualifiedResource resource;

    public MergeOperation(URI repository, QualifiedResource resource, Set<Info> infoSet, Resource base, boolean releaseLocks) {
        super(repository);
        this.resource = resource;
        this.infoSet = infoSet;
        this.base = base;
        this.releaseLocks = releaseLocks;
    }

    @Override
    protected HttpUriRequest createRequest() {
        AbstractOperation.DavTemplateRequest request = new AbstractOperation.DavTemplateRequest("MERGE", this.repository);
        if (this.releaseLocks) {
            request.addHeader("X-SVN-Options", "release-locks");
        }
        StringBuilderWriter body = new StringBuilderWriter();
        try {
            XMLStreamWriter writer = XML_OUTPUT_FACTORY.createXMLStreamWriter((Writer)body);
            writer.writeStartDocument("UTF-8", "1.0");
            writer.writeStartElement("merge");
            writer.writeDefaultNamespace("DAV:");
            writer.writeStartElement("source");
            writer.writeStartElement("href");
            writer.writeCData(this.repository.getPath() + this.resource.getValue());
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEmptyElement("no-auto-merge");
            writer.writeEmptyElement("no-checkout");
            writer.writeStartElement("prop");
            writer.writeEmptyElement("checked-in");
            writer.writeEmptyElement("version-name");
            writer.writeEmptyElement("resourcetype");
            writer.writeEmptyElement("creationdate");
            writer.writeEmptyElement("creator-displayname");
            writer.writeEndElement();
            if (!this.infoSet.isEmpty()) {
                writer.setPrefix("s", "svn:");
                writer.writeStartElement("svn:", "lock-token-list");
                writer.writeNamespace("s", "svn:");
                for (Info info : this.infoSet) {
                    Optional<LockToken> lockToken = info.getLockToken();
                    if (!lockToken.isPresent()) continue;
                    Resource infoResource = info.getResource();
                    writer.writeStartElement("svn:", "lock");
                    writer.writeStartElement("svn:", "lock-path");
                    if (Resource.ROOT.equals(this.base)) {
                        writer.writeCData(infoResource.getValueWithoutLeadingSeparator());
                    } else {
                        writer.writeCData(this.base.getValueWithoutLeadingSeparator() + infoResource.getValue());
                    }
                    writer.writeEndElement();
                    writer.writeStartElement("svn:", "lock-token");
                    writer.writeCharacters(lockToken.get().toString());
                    writer.writeEndElement();
                    writer.writeEndElement();
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.close();
        }
        catch (XMLStreamException e) {
            throw new SubversionException("could not create request body", e);
        }
        request.setEntity((HttpEntity)new StringEntity(body.toString(), CONTENT_TYPE_XML));
        return request;
    }

    @Override
    protected boolean isExpectedStatusCode(int statusCode) {
        return 200 == statusCode;
    }
}

