/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Depth;
import de.shadowhunt.subversion.Info;
import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.ResourceProperty;
import de.shadowhunt.subversion.internal.AbstractPropfindOperation;
import de.shadowhunt.subversion.internal.InfoImplReader;
import de.shadowhunt.subversion.internal.QualifiedResource;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.apache.http.HttpResponse;

class ListOperation
extends AbstractPropfindOperation<Optional<Set<Info>>> {
    private final Resource basePath;

    ListOperation(URI repository, Resource basePath, QualifiedResource resource, Resource marker, Depth depth, ResourceProperty.Key[] keys) {
        super(repository, resource, marker, depth, keys);
        this.basePath = basePath;
    }

    @Override
    protected Optional<Set<Info>> processResponse(HttpResponse response) throws IOException {
        if (ListOperation.getStatusCode(response) == 404) {
            return Optional.empty();
        }
        TreeSet<Info> result = new TreeSet<Info>(Info.RESOURCE_COMPARATOR);
        List<Info> infoList = InfoImplReader.readAll(ListOperation.getContent(response), this.basePath);
        result.addAll(infoList);
        return Optional.of(result);
    }
}

