/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.TransmissionException;
import de.shadowhunt.subversion.internal.AbstractOperation;
import de.shadowhunt.subversion.internal.QualifiedResource;
import de.shadowhunt.subversion.internal.URIUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Optional;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;

class DownloadOperation
extends AbstractOperation<Optional<InputStream>> {
    private final QualifiedResource resource;

    DownloadOperation(URI repository, QualifiedResource resource) {
        super(repository);
        this.resource = resource;
    }

    @Override
    protected HttpUriRequest createRequest() {
        URI uri = URIUtils.appendResources(this.repository, this.resource);
        return new AbstractOperation.DavTemplateRequest("GET", uri);
    }

    @Override
    public Optional<InputStream> execute(HttpClient client, HttpContext context) {
        HttpUriRequest request = this.createRequest();
        try {
            HttpResponse response = client.execute(request, context);
            if (DownloadOperation.getStatusCode(response) == 404) {
                return Optional.empty();
            }
            InputStream content = DownloadOperation.getContent(response);
            this.check(response);
            return Optional.of(content);
        }
        catch (IOException e) {
            throw new TransmissionException(e);
        }
    }

    @Override
    public Optional<InputStream> handleResponse(HttpResponse response) {
        return this.processResponse(response);
    }

    @Override
    protected boolean isExpectedStatusCode(int statusCode) {
        return 200 == statusCode || 404 == statusCode;
    }

    @Override
    protected Optional<InputStream> processResponse(HttpResponse response) {
        throw new UnsupportedOperationException();
    }
}

