/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion;

import de.shadowhunt.subversion.Repository;
import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.SubversionException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.Validate;
import org.apache.http.client.HttpClient;
import org.apache.http.protocol.HttpContext;

@ThreadSafe
public abstract class RepositoryFactory {
    private static final String DEFAULT_FRAGMENT = null;
    private static final String DEFAULT_QUERY = null;
    private static final String DEFAULT_USER_INFO = null;

    public static RepositoryFactory getInstance() throws SubversionException {
        Iterator<RepositoryFactory> iterator = ServiceLoader.load(RepositoryFactory.class).iterator();
        if (iterator.hasNext()) {
            RepositoryFactory factory = iterator.next();
            return factory;
        }
        throw new SubversionException("Can not find a RepositoryFactory");
    }

    private static URI sanitise(URI uri, Resource path) {
        try {
            return new URI(uri.getScheme(), DEFAULT_USER_INFO, uri.getHost(), uri.getPort(), path.getValue(), DEFAULT_QUERY, DEFAULT_FRAGMENT);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public final Repository createRepository(URI uri, HttpClient client, HttpContext context, boolean validate) {
        Validate.notNull((Object)uri, (String)"uri must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)client, (String)"client must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)context, (String)"context must not be null", (Object[])new Object[0]);
        URI saneUri = RepositoryFactory.sanitise(uri, Resource.create(uri.getPath()));
        return this.createRepository0(saneUri, client, context, validate);
    }

    protected abstract Repository createRepository0(URI var1, HttpClient var2, HttpContext var3, boolean var4);
}

