/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BuildProperties {
    private static final String BUILD_DATE;
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private static final Logger LOGGER;
    private static final String PROPERTIES_RESOURCE = "META-INF/build.properties";
    public static final String UNDEFINED = "UNDEFINED";
    private static final String VERSION;

    public static Optional<Date> getBuildDate() {
        if (UNDEFINED.equals(BUILD_DATE)) {
            return Optional.empty();
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_PATTERN);
        try {
            return Optional.of(dateFormat.parse(BUILD_DATE));
        }
        catch (ParseException e) {
            LOGGER.debug("could not parse date {} with pattern {}", new Object[]{BUILD_DATE, DATE_PATTERN, e});
            return Optional.empty();
        }
    }

    public static String getBuildVersion() {
        return VERSION;
    }

    public static String getUserAgent() {
        return "SVN/" + VERSION + " " + BUILD_DATE + " (https://dev.shadowhunt.de/subversion)";
    }

    private BuildProperties() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        LOGGER = LoggerFactory.getLogger(BuildProperties.class);
        Properties properties = new Properties();
        ClassLoader classLoader = BuildProperties.class.getClassLoader();
        InputStream stream = classLoader.getResourceAsStream(PROPERTIES_RESOURCE);
        if (stream != null) {
            try {
                properties.load(stream);
            }
            catch (IOException iOException) {
            }
            finally {
                IOUtils.closeQuietly((InputStream)stream);
            }
        }
        BUILD_DATE = properties.getProperty("build.date", UNDEFINED);
        VERSION = properties.getProperty("build.version", UNDEFINED);
    }
}

