/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal.httpv2;

import de.shadowhunt.subversion.Info;
import de.shadowhunt.subversion.Repository;
import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.Revision;
import de.shadowhunt.subversion.SubversionException;
import de.shadowhunt.subversion.Transaction;
import de.shadowhunt.subversion.internal.AbstractBaseRepository;
import de.shadowhunt.subversion.internal.CommitMessageOperation;
import de.shadowhunt.subversion.internal.MergeOperation;
import de.shadowhunt.subversion.internal.QualifiedResource;
import de.shadowhunt.subversion.internal.httpv2.CreateTransactionOperation;
import java.net.URI;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.Validate;
import org.apache.http.client.HttpClient;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RepositoryImpl
extends AbstractBaseRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"de.shadowhunt.subversion.Repository");

    RepositoryImpl(URI repository, Resource base, UUID id, Resource prefix, HttpClient client, HttpContext context) {
        super(repository, base, id, new ResourceMapperImpl(prefix), client, context);
    }

    @Override
    public void commit(Transaction transaction, String message, boolean releaseLocks) {
        this.validateTransaction(transaction);
        Validate.notNull((Object)message, (String)"message must not be null", (Object[])new Object[0]);
        LOGGER.trace("committing {} with message {}", (Object)transaction.getId(), (Object)message);
        if (transaction.isChangeSetEmpty()) {
            this.rollback(transaction);
            return;
        }
        QualifiedResource messageResource = this.config.getCommitMessageResource(transaction);
        CommitMessageOperation cmo = new CommitMessageOperation(this.repository, messageResource, message);
        cmo.execute(this.client, this.context);
        Set<Info> lockTokenInfoSet = this.getInfoSetWithLockTokens(transaction);
        QualifiedResource mergeResource = this.config.getTransactionResource(transaction);
        MergeOperation mo = new MergeOperation(this.repository, mergeResource, lockTokenInfoSet, this.base, releaseLocks);
        mo.execute(this.client, this.context);
        transaction.invalidate();
    }

    @Override
    public Transaction createTransaction() {
        LOGGER.trace("creating new transaction");
        QualifiedResource resource = this.config.getCreateTransactionResource();
        Revision headRevision = this.determineHeadRevision();
        CreateTransactionOperation cto = new CreateTransactionOperation(this.repository, this.repositoryId, resource, headRevision);
        return (Transaction)cto.execute(this.client, this.context);
    }

    @Override
    public Repository.ProtocolVersion getProtocolVersion() {
        return Repository.ProtocolVersion.HTTP_V2;
    }

    @Override
    protected void registerResource(Transaction transaction, Resource resource, Revision revision) {
        this.validateTransaction(transaction);
        transaction.register(resource, Transaction.Status.EXISTS);
    }

    private static class ResourceMapperImpl
    implements AbstractBaseRepository.ResourceMapper {
        private static final Resource CREATE_TRANSACTION = Resource.create("me");
        private final Resource prefix;

        ResourceMapperImpl(Resource prefix) {
            this.prefix = prefix;
        }

        @Override
        public QualifiedResource getCommitMessageResource(Transaction transaction) {
            Resource suffix = Resource.create("/txn/" + transaction.getId());
            return new QualifiedResource(this.prefix, suffix);
        }

        @Override
        public QualifiedResource getCreateTransactionResource() {
            return new QualifiedResource(this.prefix, CREATE_TRANSACTION);
        }

        @Override
        public Resource getPrefix() {
            return this.prefix;
        }

        @Override
        public QualifiedResource getRegisterResource(QualifiedResource resource, Revision revision) {
            throw new UnsupportedOperationException("Not supported by httpv2");
        }

        @Override
        public QualifiedResource getRegisterTransactionResource(Transaction transaction) {
            throw new UnsupportedOperationException("Not supported by httpv2");
        }

        @Override
        public QualifiedResource getTransactionResource(Transaction transaction) {
            return this.getCommitMessageResource(transaction);
        }

        @Override
        public QualifiedResource getVersionedResource(QualifiedResource resource, Revision revision) {
            if (Revision.HEAD.equals(revision)) {
                throw new SubversionException("must not be HEAD revision");
            }
            Resource suffix = Resource.create("/rvr/" + revision + "/" + resource.getValue());
            return new QualifiedResource(this.prefix, suffix);
        }

        @Override
        public QualifiedResource getWorkingResource(Transaction transaction) {
            Resource suffix = Resource.create("/txr/" + transaction.getId());
            return new QualifiedResource(this.prefix, suffix);
        }
    }
}

