/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal.httpv1;

import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.Revision;
import de.shadowhunt.subversion.internal.AbstractOperation;
import de.shadowhunt.subversion.internal.QualifiedResource;
import de.shadowhunt.subversion.internal.TransactionImpl;
import de.shadowhunt.subversion.internal.URIUtils;
import java.net.URI;
import java.util.UUID;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;

class CreateTransactionOperation
extends AbstractOperation<TransactionImpl> {
    private final Revision headRevision;
    private final UUID repositoryId;
    private final QualifiedResource resource;
    private final UUID transactionId = UUID.randomUUID();

    CreateTransactionOperation(URI repository, UUID repositoryId, QualifiedResource resource, Revision headRevision) {
        super(repository);
        this.repositoryId = repositoryId;
        this.resource = resource;
        this.headRevision = headRevision;
    }

    @Override
    protected HttpUriRequest createRequest() {
        URI uri = URIUtils.appendResources(this.repository, this.resource.getBase(), this.resource.getResource(), Resource.create(this.transactionId.toString()));
        return new AbstractOperation.DavTemplateRequest("MKACTIVITY", uri);
    }

    @Override
    protected boolean isExpectedStatusCode(int statusCode) {
        return 201 == statusCode;
    }

    @Override
    protected TransactionImpl processResponse(HttpResponse response) {
        return new TransactionImpl(this.transactionId.toString(), this.repositoryId, this.headRevision);
    }
}

