/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal.httpv1;

import de.shadowhunt.subversion.SubversionException;
import de.shadowhunt.subversion.internal.AbstractOperation;
import de.shadowhunt.subversion.internal.AbstractVoidOperation;
import de.shadowhunt.subversion.internal.QualifiedResource;
import de.shadowhunt.subversion.internal.URIUtils;
import java.io.Writer;
import java.net.URI;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.io.output.StringBuilderWriter;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;

class CheckoutOperation
extends AbstractVoidOperation {
    private final QualifiedResource resource;
    private final QualifiedResource transaction;

    CheckoutOperation(URI repository, QualifiedResource resource, QualifiedResource transaction) {
        super(repository);
        this.resource = resource;
        this.transaction = transaction;
    }

    @Override
    protected HttpUriRequest createRequest() {
        StringBuilderWriter body = new StringBuilderWriter();
        try {
            XMLStreamWriter writer = XML_OUTPUT_FACTORY.createXMLStreamWriter((Writer)body);
            writer.writeStartDocument("UTF-8", "1.0");
            writer.writeStartElement("checkout");
            writer.writeDefaultNamespace("DAV:");
            writer.writeStartElement("activity-set");
            writer.writeStartElement("href");
            URI transactionURI = URIUtils.appendResources(this.repository, this.transaction);
            writer.writeCData(transactionURI.toString());
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEmptyElement("apply-to-version");
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.close();
        }
        catch (XMLStreamException e) {
            throw new SubversionException("could not create request body", e);
        }
        URI uri = URIUtils.appendResources(this.repository, this.resource);
        AbstractOperation.DavTemplateRequest request = new AbstractOperation.DavTemplateRequest("CHECKOUT", uri);
        request.setEntity((HttpEntity)new StringEntity(body.toString(), CONTENT_TYPE_XML));
        return request;
    }

    @Override
    protected boolean isExpectedStatusCode(int statusCode) {
        return 201 == statusCode;
    }
}

