/*
 * Decompiled with CFR 0.152.
 */
package de.shadowhunt.subversion.internal;

import de.shadowhunt.subversion.Resource;
import de.shadowhunt.subversion.Revision;
import de.shadowhunt.subversion.Transaction;
import de.shadowhunt.subversion.View;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.commons.lang3.Validate;

public final class TransactionImpl
implements Transaction,
View {
    private boolean active = true;
    private final Map<Resource, Transaction.Status> changeSet = new TreeMap<Resource, Transaction.Status>();
    private final Revision headRevision;
    private final String id;
    private final UUID repositoryId;

    public TransactionImpl(String id, UUID repositoryId, Revision headRevision) {
        Validate.notNull((Object)id, (String)"id must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)repositoryId, (String)"repositoryId must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)headRevision, (String)"headRevision must not be null", (Object[])new Object[0]);
        this.id = id;
        this.repositoryId = repositoryId;
        this.headRevision = headRevision;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TransactionImpl)) {
            return false;
        }
        TransactionImpl that = (TransactionImpl)o;
        return this.id.equals(that.id);
    }

    @Override
    public Map<Resource, Transaction.Status> getChangeSet() {
        return new TreeMap<Resource, Transaction.Status>(this.changeSet);
    }

    @Override
    public Revision getHeadRevision() {
        return this.headRevision;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public UUID getRepositoryId() {
        return this.repositoryId;
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + this.getRepositoryId().hashCode();
        return result;
    }

    @Override
    public void invalidate() {
        this.active = false;
        this.changeSet.clear();
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean isChangeSetEmpty() {
        if (this.changeSet.isEmpty()) {
            return true;
        }
        for (Transaction.Status status : this.changeSet.values()) {
            if (status == Transaction.Status.EXISTS) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean register(Resource resource, Transaction.Status status) {
        Validate.notNull((Object)resource, (String)"resource must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)status), (String)"status must not be null", (Object[])new Object[0]);
        Transaction.Status old = this.changeSet.put(resource, status);
        if (old != null) {
            if (Transaction.Status.ADDED == old && Transaction.Status.DELETED == status) {
                this.changeSet.remove(resource);
                return true;
            }
            if (old.order > status.order) {
                this.changeSet.put(resource, old);
                return false;
            }
        }
        return true;
    }

    public Transaction.Status status(Resource resource) {
        Validate.notNull((Object)resource, (String)"resource must not be null", (Object[])new Object[0]);
        Transaction.Status status = this.changeSet.get(resource);
        if (status != null) {
            return status;
        }
        return Transaction.Status.NOT_TRACKED;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Transaction [");
        sb.append("id=").append(this.id);
        sb.append(", repositoryId=").append(this.getRepositoryId());
        sb.append(", active=").append(this.active);
        sb.append(']');
        return sb.toString();
    }
}

